#simple linear birth/death process
#as monomlecular reactions
simbirthdeath1<-function(...,init=1,brate=1,drate=1){
  #+1 - birth, -1 - death
  switchvec<-matrix(data=c(1,-1),nrow=2,ncol=1);
  #monomolecular 'reactions'
  reacmatrix<-matrix(data=c(1,0,1,0),nrow=2,ncol=2,byrow=TRUE);
  sim.chem.jump(init=c(init),switchvec=switchvec,
                reacmatrix=reacmatrix,
                rates=c(brate, drate),names=c("N"),...)
}

plot(simbirthdeath1(seed=1,tmax=10,nmax=1e4,init=10,brate=1,drate=1),type="S")

# the same as markov jump process
simbirthdeath2<-function(...,init=1,brate=1,drate=1){
  #+1 - birth, -1 - death
  switchfun<-function(u,i) (-1)^(i-1)
  ratefun<-function(u) {c( brate*u[1], drate*u[1])};
  sim.general.jump(init=c(init),
                   switchfunc=switchfun,
                   ratesfunc=ratefun,
                   names=c("N"),
                   ...)
}

plot(simbirthdeath2(seed=1,tmax=10,nmax=1e4,init=10,brate=1,drate=1),type="S")


