\encoding{utf8}
\name{sim.general.jump}
\title{Simulation of Markov jump processes}
\alias{sim.general.jump}
\usage{
sim.general.jump(nmax=1e4,init=c(1),
                        names=paste("V",1:length(init)),
                        switchfunc=function(...)0.,
                        ratesfunc=function(...)1., 
                           tmax=1,
                        seed=1)
}
\arguments{
  \item{nmax}{maximal number of jumps to be simulated}
  \item{init}{initial value}
  \item{names}{names of variables}
  \item{switchfunc}{a function evaluating the jump vector}          
  \item{ratesfunc}{a function evaluating the ratesvector}
    \item{tmax}{maximal time}
      \item{seed}{seed for random numbers}


}
\description{
 \code{sim.general.jump} simulates a general Markov jump process
}
\details{Simulations are done by simulating just the next reaction, similar to  the original Gillespie algorithm.

If \code{init} is a \code{q} dimensional vector and there are \code{k} different jump types, \code{switchfunc(u,i)} shall return the \code{i}th jump vector in state \code{u} and \code{ratefunc(u)} shall return the \code{k} dimensional vector of jump rates in state \code{u}.}
\value{A matrix \code{out} with 
 \itemize{ \item{\code{out[,1]} being the times of jumps } 
  \item{\code{out[i,2:(length(init)+1])} state vector just after time \code{out[i,1]} } 
}
}
\references{
Gillespie, D. T. (1977). "Exact stochastic simulation of coupled chemical reactions". Journal of Physical Chemistry 81: 2340–2361}
\author{Volkmar Liebscher}

\keyword{Markov jump process, Gillespie algorithm}
