#include <malloc.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <R.h>
#include <Rinternals.h>




void sim_chemr(int *nmax,int *nmax1, double *init, double *tmax, int *comp,int *comp1, int *nreac0,int reactab[2][*nreac0], double rates[*nreac0],
	double switchvec[*comp][*nreac0],double exps[*nmax],double sims[*nmax],double out[*nmax1][*comp1] )
/* 
nmax simulationen
init Start
comp # Spezies +1
nreac0 # Reaktionen
reactab # Reaktanten
rates Raten 
switchvec Delta Stöchiometrie
exp Exponentialverteilungen
sims Gleichverteilungen
out Ausgabe
*/ 
{ 	int i,ic,ir,jl,k=0;
	double s,t,rv[*nreac0];
	GetRNGstate();
	out[0][0]=0.;
	for(ic=1;ic<*comp1;ic++){
	out[0][ic]=init[ic-1];
	}; 
/*for(ir=0;ir<*nreac0;ir++) for(ic=0;ic<*comp;ic++) printf("ir:%2d ic:%3d sv:%3e\n",ir, ic,switchvec[ic][ir]);
printf("hallo\n");
for(ir=0;ir<*nreac0;ir++) for(ic=0;ic<2;ic++) printf("ir:%2d ic:%3d rt:%3d\n",ir, ic,reactab[ic][ir]);
printf("hallo\n");*/
	for(i=0;i<*nmax;i++){ /*printf("i:%2d nr: %3d\n",i,nreac0);*/
	s=0.;
	for(ir=0;ir<*nreac0;ir++) { /*printf("%2d %3d",i,ir);*/if (reactab[1][ir]==0)
	{s+=rates[ir]*init[reactab[0][ir]-1];	
	rv[ir]=s;
	}
	else {if (reactab[1][ir]==reactab[0][ir])
	{s+=rates[ir]*init[reactab[1][ir]-1]*(init[reactab[1][ir]-1]-1.)/2;
	rv[ir]=s;
/*	printf("hallo: %4d:%4d\n",i,ir);*/
	}
	else	
	{s+=rates[ir]*init[reactab[1][ir]-1]*init[reactab[0][ir]-1];	
	rv[ir]=s;
	};
	};};
/*printf("%2d",i);*/
	if (s>0.)
        {out[i+1][0]=out[i][0]+exps[i]/s;
	s*=sims[i];
	t=0.;	
	for(ir=0;t<s;ir++) t=rv[ir];
	ir--; 	
	for(ic=0;ic<*comp;ic++){init[ic]+=switchvec[ic][ir];
	out[i+1][ic+1]=init[ic];
	};
	} else 
	{k=2;
	break;
	};
	if(out[i+1][0]>*tmax) {k=1;break;};
	};
/*printf("%5d %5d\n",i,k);*/
	if (k>=1) { 
	for(ic=1;ic<*comp1;ic++){
	out[i+1][ic]=out[i][ic];};
	out[i+1][0]=*tmax;
	*nmax=i+1;
	};
	PutRNGstate();
}



SEXP sim_general(SEXP nmaxt, SEXP init, SEXP tmax,  SEXP  switchfunc, SEXP envirs,SEXP  ratesfunc, SEXP envirr)
/* 
nmax simulationen
init Start
comp # Spezies +1
nreac # Reaktionen
ratesfunc Raten ortsabhängig
switchfunc Delta ortsabhängig
exp Exponentialverteilungen
sims Gleichverteilungen
out Ausgabe
*/ 
{ 	int i,ic,ir,jl,k=0,nreac,nreac1,nmax0=INTEGER(nmaxt)[0],nmax1,comp0=LENGTH(init),comp1;
	nmax1=nmax0+1;
	comp1=comp0+1;
	double s,t,sv[comp0],*rout,*rout1,*rinit,*rans,rtmax;
	SEXP R_fcall, ans,nR,outs,out,vinit;
 PROTECT(R_fcall = lang2(ratesfunc,init));   
  PROTECT(ans = eval(R_fcall, envirr));  
nreac=LENGTH(ans);
nreac1=nreac+1;
double rv[nreac1];
UNPROTECT(2);
	GetRNGstate();
PROTECT(nR=allocVector(INTSXP,1));
PROTECT(ans=allocVector(REALSXP,comp0));
PROTECT(vinit=allocVector(REALSXP,comp0));
rinit=REAL(vinit);
PROTECT(outs=allocMatrix(REALSXP,nmax1,comp1));
rout=REAL(outs);
	for(ic=0;ic<comp0;ic++){
		rinit[ic]=REAL(init)[ic];};
rtmax=REAL(tmax)[0];
	for(ic=0;ic<comp0;ic++){
		rout[0]=0.;
		rout[nmax1*(ic+1)]=rinit[ic];};
/*for(ir=0;ir<nreac0;ir++) for(ic=0;ic<*comp;ic++) printf("ir:%2d ic:%3d sv:%3e\n",ir, ic,switchvec[ic][ir]);
printf("hallo\n");
for(ir=0;ir<nreac0;ir++) for(ic=0;ic<2;ic++) printf("ir:%2d ic:%3d rt:%3d\n",ir, ic,reactab[ic][ir]);
printf("hallo\n");*/
	for(i=0;i<nmax0;i++){ /*printf("i:%2d nr: %3d\n",i,nreac0);*/
 PROTECT(R_fcall = lang2(ratesfunc,vinit));   
  PROTECT(ans = eval(R_fcall, envirr));  
	s=0.;rans=REAL(ans);
	for(ir=0;ir<nreac;ir++) {s+=(rans[ir] >0) ? rans[ir] :0.;	
	rv[ir]=s;
	}
UNPROTECT(2);
/*printf("%2d %3e %3e %3e %3e\n",i,rinit[0],rinit[1],rv[0],rv[1]);*/
	if (s>0.)
        {rout[i+1]=rout[i]+exp_rand()/s;
	s*=unif_rand();
	t=0.;	
	for(ir=0;t<s;ir++) {t=rv[ir];};
	INTEGER(nR)[0]=ir;
  PROTECT(R_fcall = lang3(switchfunc,vinit,nR));   
  PROTECT(ans = eval(R_fcall, envirs));  
	rans=REAL(ans);
	for(ic=0;ic<comp0;ic++){rinit[ic]+=rans[ic];
	rout[i+1+nmax1*(ic+1)]=rinit[ic];}
/*printf("%2d \n",ir);*/
UNPROTECT(2);
	} else 
	{k=2;
	break;
	};
	if(rout[i+1]>rtmax) {k=1;break;};
	};
/*printf("%5d %5d\n",i,k);*/
	if (k>=1) { 
	for(ic=1;ic<comp1;ic++){
	rout[i+1+nmax1*ic]=rout[i+nmax1*ic];};
	rout[i+1]=rtmax;
	nmax0=i+1;
	};
PROTECT(out=allocMatrix(REALSXP,nmax0+1,comp1));
rout1=REAL(out);
	for(jl=0;jl<nmax0+1;jl++){
	for(ic=0;ic<comp1;ic++){
		rout1[jl+(nmax0+1)*ic]=rout[jl+nmax1*ic];};};
UNPROTECT(5);
	PutRNGstate();
return(out);
}



