
setClass("pdmpModel",
         representation(
           parms  = "numericOrlist",
           init   = "numeric",
           times   = "numeric",
           dynfunc="function",
           jumpfunc="function",
           ratefunc="function"
         ),
         contains = "simObj"
)


pdmpModel  <- function(obj=NULL,  dynfunc=function(t,z,parms)0.*z,jumpfunc=function(t,z,parms,jtype)z,ratefunc=function(t,z,parms)c(0),
                       times=c(from=0, to=10, by=1),
                       init=c(0,0), parms=c(0),
                       solver="lsodar") 
  {
    obj <- new("pdmpModel", dynfunc=dynfunc,jumpfunc=jumpfunc,ratefunc=ratefunc,
                times=times,
               init=init, parms=parms,  solver=solver,
               out=out)
    invisible(obj)
  }

setMethod("sim", "pdmpModel",
          function(obj,initialize=FALSE,  seed=1,outrate=FALSE,nroot=1e6,...) {set.seed(seed)
            times             <- fromtoby(obj@times)
            parms<-obj@parms
            objdim<-length(obj@init)
            func              <- function(t,y,parms){list(c(obj@dynfunc(t,z=y[-objdim-1],parms=obj@parms),sum(obj@ratefunc(t=t,z=y[-objdim-1],parms=obj@parms))))}
            rootfunc <-function(t,y,parms)y[objdim+1]
            eventfunc<-function(t,y,parms){w<-obj@ratefunc(t=t,z=y[-objdim-1],parms=obj@parms);
                                                    jtype<-sample.int(n=length(w),size=1,prob=w);return(c(obj@jumpfunc(t=t,z=y[-objdim-1],parms=obj@parms,jtype=jtype),-rexp(n=1)))}
              events<-list(func=eventfunc,root=TRUE,rootfunc=rootfunc)
            inity<-c(obj@init,-rexp(n=1))
            names(inity)<-c(names(obj@init),"pdmpsim:negcumrate")
            if(outrate){
              out <- do.call(obj@solver, list(y=inity, times=times, func=func, initpar=obj@parms, events=events,rootfunc=rootfunc,nroot=nroot,...))}
            else{              out <- do.call(obj@solver, list(y=inity, times=times, func=func, initpar=obj@parms, events=events,rootfunc=rootfunc,nroot=nroot,...))[,-objdim-2]
            class(out)<-"deSolve"}
            obj@out<-out
            invisible(out)
          }
)

setGeneric("dynfunc", function(obj, ...) standardGeneric("dynfunc"))
setGeneric("dynfunc<-", function(obj,value) standardGeneric("dynfunc<-"))

setGeneric("ratefunc", function(obj, ...) standardGeneric("ratefunc"))
setGeneric("ratefunc<-", function(obj, value) standardGeneric("ratefunc<-"))
setGeneric("jumpfunc", function(obj, ...) standardGeneric("jumpfunc"))
setGeneric("jumpfunc<-", function(obj, value) standardGeneric("jumpfunc<-"))


setMethod("dynfunc", "pdmpModel",function(obj,...) obj@dynfunc)

setMethod("dynfunc<-", "pdmpModel",function(obj,value) {obj@dynfunc<-value;
                                                      obj@out<-NULL
invisible(obj)}
          )

setMethod("ratefunc", "pdmpModel",function(obj,...) obj@ratefunc)
setMethod("ratefunc<-", "pdmpModel",function(obj,value) {obj@ratefunc<-value;
                                                      obj@out<-NULL
invisible(obj)}
)
setMethod("jumpfunc", "pdmpModel",function(obj,...) obj@jumpfunc)
setMethod("jumpfunc<-", "pdmpModel",function(obj,value) {obj@jumpfunc<-value;
                                                      obj@out<-NULL
invisible(obj)}
)
