#selfactivator model
activat<-new("pdmpModel",
    parms=list(delta=1,alpha=1,mum=.2,mup=.2,nu=.2),
    init=c(x=0.5,xi=1),
    dynfunc=function(t,z,parms){dx<- with(as.list(c(z,parms)),{-delta*x+alpha*xi})
                                return(c(dx,0))
    },
    ratefunc=function(t,z,parms){return( with(as.list(c(z,parms)), switch(xi+1,mup*x+nu,mum)
    ))},
    jumpfunc=function(t,z,parms,jtype){c(z[1],1-z[2])},
    times=c(from=0,to=1e2,by=1e-1),
    solver="lsodar"
)
plot(sim(activat,seed=1))
plot(sim(activat,seed=2))