# example model by Benaim et al 2012
#depending on switch rate mu the PDMP is contracted towards the origin or tends to infinity
planarlinswitch<-new("pdmpModel",
                     parms=list(b=2,mu=1),
                     init=c(x=1,y=1,xi=1),
                     dynfunc=function(t,z,parms){dx<- with(as.list(c(z,parms)),{switch(xi,c(-x+2*b*y,-y,0),c(-x,+2*b*x-y,0))})
                                                 return(dx)
                     },
                     ratefunc=function(t,z,parms){return( with(as.list(c(z,parms)), mu))},
                     jumpfunc=function(t,z,parms,jtype){with(as.list(c(z,parms)), c(x,y,3-xi))},
                     times=c(from=0,to=10,by=1e-2),
                     solver="lsodar"
)
#slow
parms(planarlinswitch)<-list(b=1.8,mu=.1)
times(planarlinswitch)<-c(from=0,to=2e1,by=1e-2)
    plot(sim(planarlinswitch,seed=42))
title(main="slow planar switch PDMP",outer=TRUE)

     #fast
     parms(planarlinswitch)<-list(b=1.8,mu=10)
     times(planarlinswitch)<-c(from=0,to=1e1,by=1e-2)
     plot(sim(planarlinswitch,seed=42))
title(main="fast planar switch PDMP",outer=TRUE)
          