#toggle switch
#xi=1 A blocks  B and vice versa
#xi=2 Ablocks B but B not A
#xi=3  B blocks A but A not B
#xi=4 nothing blocked
#jtype=1: promotor B changes (A binds/dysbinds) 
#jtype=2: promotor A changes (B binds/dysbinds) 
toggleswitch<-new("pdmpModel",
                  parms=list(delta1=1,delta2=1,alpha1=1,alpha2=1,mum1=1,mum2=1,mup1=1,mup2=1),
                  init=c(x1=0.5,x2=0.5,xi=4),
                  dynfunc=function(t,z,parms){dx<- with(as.list(c(z,parms)),c(-delta1*x1,-delta2*x2)+switch(xi,c(0,0),c(alpha1,0),c(0,alpha2),c(alpha1,alpha2)))
                                              return(c(dx,0))
                  },
                  ratefunc=function(t,z,parms){return( with(as.list(c(z,parms)), c(switch(xi,mup1,mup1,mum1*x1,mum1*x1),switch(xi,mup2,mum2*x2,mup2,mum2*x2))))},
                  jumpfunc=function(t,z,parms,jtype){c(z[1:2],switch(jtype,switch(z[3],3,4,1,2),switch(z[3],2,1,4,3)))},
                  times=c(from=0,to=1e1,by=1e-2),
                  solver="lsodar"
)

outtoggle<-sim(toggleswitch,seed=42)
matplot(outtoggle[,1],outtoggle[,2:4],col=c(2,3,4),lty=c(1,1,3))