#selfinhibitor model
inhibit<-new("pdmpModel",
             parms=list(delta=1,alpha=1,mum=1,mup=1),
             init=c(x=0.5,xi=1),
             dynfunc=function(t,z,parms){dx<- with(as.list(c(z,parms)),{-delta*x+alpha*xi})
                                         return(c(dx,0))
             },
             ratefunc=function(t,z,parms){return( with(as.list(c(z,parms)), switch(xi+1,mup,mum*x)
             ))},
             jumpfunc=function(t,z,parms,jtype){c(z[1],1-z[2])},
             times=c(from=0,to=1e2,by=1e-1),
             solver="lsodar"
)
plot(sim(inhibit,seed=1))
plot(sim(inhibit,seed=2))