#inhibition with two promotors

inhibit2<-new("pdmpModel",
              parms=list(delta=1,alpha=1,mum=.1,mup=.1),
              init=c(x=0.5,xi=2),
              dynfunc=function(t,z,parms){dx<- with(as.list(c(z,parms)),{-delta*x+alpha*xi})
                                          return(c(dx,0))
              },
              ratefunc=function(t,z,parms){return( with(as.list(c(z,parms)), c(switch(xi+1,2*mup,mup,0),switch(xi+1,0,mum*x,2*mum*x))))},
              jumpfunc=function(t,z,parms,jtype){c(z[1],z[2]+switch(jtype,1,-1))},
              times=c(from=0,to=2e3,by=1e-2),
              solver="lsodar"
)

outiii<-sim(inhibit2,seed=42)
matplot(outiii[,1],outiii[,2:3],type="l",xlab="time",ylab=expression(p*","*xi),lty=1,lwd=3,col=1:2)