\name{pdmpModel}
\title{Simulating piecewise deterministic Markov process models}
\alias{sim}
\alias{sim,pdmpModel-method}
\alias{new,pdmpModel-method}
\alias{pdmpModel}
\alias{pdmpModel-class}
\usage{pdmpModel(obj=NULL,  dynfunc=function(t,z,parms)0.*z,jumpfunc=function(t,z,parms,jtype)z,ratefunc=function(t,z,parms)c(0),times=c(from=0, to=10, by=1),init=c(0,0), parms=c(0),solver="lsodar") 
\S4method{sim}{pdmpModel}(obj,initialize=FALSE, seed=1,outrate=FALSE,nroot=1e6,...)}
\arguments{\item{z}{a vector containing both the discrete and continuous components}
\item{t}{time}
\item{parms}{Parameters, either a list or a vector}
\item{jtype}{integer enumerating the different jump types}
\item{dynfunc}{the  vector field of the deterministic motion. Note that the discrete components should be altered.}
\item{jumpfunc}{a function simulating the (random) jumps}
\item{ratefunc}{a function computing a vector of jumprates, with the index running over the different jump types}
\item{init, times}{like in \link{simecol-package} package}
\item{solver}{function for solving the deterministic equations. It should be able to manage events and root finding like \link{lsodar}.}
\item{seed}{random seed to choose for the simulation}
\item{outrate}{logical controlling output of the cumulated jump rates}
\item{nroot}{maximal number of jumps to simulate}
\item{initialize}{logical, should the object be initialised before simulation?}
\item{obj}{pdmpmodel object}
\item{...}{additional arguments for simulation (see \link{simecol-package} documentation}
}
\description{
  \code{pdmpModel} Creates a pdmpmodel
}
\details{The function \code{dynfunc} should return the vector field of the deterministic motion between the jumps of the process.

The function \code{ratefunc} returns a vector of jump rates. Each elemnt of this vectors gives the rate for a jump of a special type, indexed by \code{jtype}.  For this kind of jump the function \code{jumpfunc} returns a simulated result of this jump, a  state vector giving both a new dicrete and continuous component.  

The simulation provided by the \code{sim} method is the variant of the Gillespie algorithm proposed in \cite{Zeiser et al. 2008}. For this goal, the \code{solver} must be able to find roots. The algorithm was tested with the \code{lsodar} solver only upto now. 
}
\value{An object ready for simulating the PDMP. The plot method for the output is derived from the \code{deSolve-package} class. 
}
\references{
Zeiser S, Franz U, Wittich O, Liebscher V. Simulation of genetic networks modelled by piecewise deterministic Markov processes. IET SYST BIOL 2008, 2(3):113-135

Davis, M.H.A.
Piecewise-deterministic Markov processes: A general class of non- diffusion stochastic models. 
J. R. Stat. Soc., Ser. B 46, 353-388 (1984)}
\author{Volkmar Liebscher}
\seealso{
  \code{\link{odeModel}}, \code{\link{deSolve-package}}.
}
\keyword{piecewise deterministic Markov processes}
