#library("lpSolve")
# 
# setwd("~/TeX/ideas/pottsconsistency/R/phylopotts")
# 
# library("glpkAPI")
library("gromovlab")
library("distory")
library("quadprog")
library("igraph")
library("phangorn")

PDinf<-function(d1,d2){max(abs(d1-d2))}
PDl2<-function(d1,d2){sqrt(sum((d1-d2)^2))}
PDl1<-function(d1,d2){sum(abs(d1-d2))}






md2<-function(n=1e1,dfun=function(t1,t2)gromovdist(type="l1",t1,t2))
                                {return(system.time({dfun(rtree(n=n),rtree(n=n))})[1])}


nsim<-1e3
set.seed(1); 
ups1<-replicate(n=nsim,{md2(1e2)})
set.seed(1); 
ups3<-replicate(n=nsim,{md2(1e2,dfun=function(t1,t2)gromovdist(type="l2",t1,t2))})
set.seed(1); 
ups5<-replicate(n=nsim,{md2(1e2,dfun=function(t1,t2)gromovdist(type="linf",t1,t2))})
set.seed(1); 
ups7<-replicate(n=nsim,{md2(1e2,dfun=function(t1,t2)PDl1(cophenetic(t1),cophenetic(t2)))})
set.seed(1); 
ups9<-replicate(n=nsim,{md2(1e2,dfun=function(t1,t2)PDl2(cophenetic(t1),cophenetic(t2)))})
set.seed(1); 
ups11<-replicate(n=nsim,{md2(1e2,dfun=function(t1,t2)dist.multiPhylo(list(t1,t2)))})
set.seed(1); 
ups13<-replicate(n=nsim,{md2(1e2,dfun=function(t1,t2)RF.dist(t1,t2))})

upse<-data.frame(type=factor(rep(c("l1","l2","linf","PDl1","PDl2","BHV","RF"),each=nsim),levels=c("l1","l2","linf","PDl1","PDl2","BHV","RF")),time=c(ups1,ups3,ups5,ups7,ups9,ups11,ups13)+1e-3)
#upsev<-data.frame(type=factor(rep(paste(rep(c("l1","l2","linf","PDl1","PDl2","BHV","RF"),each=2),sep="/",c(100,200)),each=nsim),levels=paste(rep(c("l1","l2","linf","PDl1","PDl2","BHV","RF"),each=2),sep="/",c(100,200))),time=c(ups1,ups2,ups3,ups4,ups5,ups6,ups7,ups8,ups9,ups10,ups11,ups12,ups13,ups14))
postscript("timesbpfnn.eps")
plot(time~type,data=upse,log="y",
     main=expression("computing times of tree metrics, "*{n==100}),names=c(expression(D[1]),expression(D[2]),expression(D[infinity]^"pd"),expression(D[1]^"pd"),expression(D[2]^"pd"),"BHV","RF"),ylab="computing time [s]")                                                                                                                                                                                                                                                    
#plot(time~type,data=upsev,log="y",
#     main=expression("computing times of tree metrics, "*{n==100*","*200}))                                                                                                                                                                                                                                                    
dev.off()

#weighted
rdist<-function(n=1e2,nn=1e1,seed=1)
{set.seed(seed)
 ee<-  replicate(n=n,{xy1<-rtree(n=nn)
                      xy2<-rtree(n=nn)
                      d1<-cophenetic(xy1)
                      d2<-cophenetic(xy2)
                      c(l1=gromovdist(type="l1",xy1,xy2),l2=gromovdist(type="l2",xy1,xy2),linf=gromovdist(type="linfinity",xy1,xy2),PD1=PDl1(d1,d2),PD2=PDl2(d1,d2),BHV=dist.multiPhylo(list(xy1,xy2),outgroup="t1"),RF=RF.dist(xy1,xy2))})
 return(as.data.frame(t(ee)))
}
#unweighted
rdistd<-function(n=1e2,nn=1e1,seed=1)
{set.seed(seed)
 ee<-  replicate(n=n,{xy1<-rtree(n=nn,rooted=FALSE,br=1)
                      xy2<-rtree(n=nn,rooted=FALSE,br=1)
                      d1<-cophenetic(xy1)
                      d2<-cophenetic(xy2)
                      c(l1=gromovdist(type="l1",xy1,xy2),l2=gromovdist(type="l2",xy1,xy2),linf=gromovdist(type="linfinity",xy1,xy2),PD1=PDl1(d1,d2),PD2=PDl2(d1,d2),BHV=dist.multiPhylo(list(xy1,xy2),outgroup="t1"),RF=RF.dist(xy1,xy2))})
 return(as.data.frame(t(ee)))
}
#caterpillars
rdistc<-function(n=1e2,nn=1e1,seed=1)
{set.seed(seed)
 ee<-  replicate(n=n,{xy1<-unroot(stree(n=nn,"left"));xy1$edge.length<-rep(1,2*nn-3);
                      xy2<-xy1;xy2$tip.label<-xy1$tip.label[sample(nn,nn)]
                      d1<-cophenetic(xy1)
                      d2<-cophenetic(xy2)[xy1$tip.label,xy1$tip.label]
                      c(l1=gromovdist(type="l1",xy1,xy2),l2=gromovdist(type="l2",xy1,xy2),linf=gromovdist(type="linfinity",xy1,xy2),PD1=PDl1(d1,d2),PD2=PDl2(d1,d2),BHV=dist.multiPhylo(list(xy1,xy2),outgroup="t1"),RF=RF.dist(xy1,xy2))})
 return(as.data.frame(t(ee)))
}


abdf<-rdist(n=1e3,nn=1e1)

postscript("distrwtreesn.eps")
plot(abdf,labels=c(expression(D[1]),expression(D[2]),expression(D[infinity]^"pd"),expression(D[1]^"pd"),expression(D[2]^"pd"),"BHV","RF"))
dev.off()

abdg<-rdistd(n=1e3,nn=10)
postscript("distrtreesn.eps")
plot(abdg,labels=c(expression(D[1]),expression(D[2]),expression(D[infinity]^"pd"),expression(D[1]^"pd"),expression(D[2]^"pd"),"BHV","RF"))
dev.off()

postscript("D1ganzn.eps")
plot(table(abdg[,1]),main=expression("frequencies of "*D[1](tau[1],tau[2])),ylab="frequency",lwd=3)
dev.off()
abdh<-rdistc(n=1e3,nn=10)

postscript("rangeD1catn.eps")
plot(table(abdh[,1]),main=expression("frequencies of "*D[1](tau[1],tau[2])),ylab="frequency",lwd=3)
abline(v=17,lty=2)
dev.off()





#concerning the euclideaness of D_2
#different quadratic programs (also dual)
ddl<-function(l,abc=rep(1,3)){
  return((solve.QP(Dmat=2*diag(abc),dvec=rep(0,3),bvec=abs(c(l[1],l[2],l[1]+l[2])),Amat=matrix(c(1,1,0,0,1,1,1,0,1),nc=3,byrow=FALSE)))$value)}
ddl2<-function(l,abc=rep(1,3)){a<-1/abc[1];b<-1/abc[2];c<-1/abc[3]
return(-(solve.QP(Dmat=0.5*matrix(c(a+b,-b,-b,b+c),nc=2,nr=2),dvec=l,bvec=rep(0,2),Amat=diag(rep(1,2)))$value))}
ddls111<-replicate(1e3,{l1<-runif(n=2)
              c(ddl(l1),ddl2(l1))})
plot(as.data.frame(t(ddls111)))
ddl3<-function(l,abc=rep(1,3)){a<-1/abc[1];b<-1/abc[2];c<-1/abc[3]
        
                               return(t(l)%*%solve(matrix(c(a+b,-b,-b,b+c),nc=2,nr=2))%*%l)}
}}}
ddls112<-replicate(1e3,{l1<-runif(n=2)
                        c(ddl(l1),ddl2(l1),ddl3(l1))})
plot(as.data.frame(t(ddls112)))

fiven<-function(l,abc){a<-abc[1];b<-abc[2];c<-abc[3]
                       am<-(b*abs(l[1])+c*abs(sum(l)))/sum(abc);if(am>abs(l[1])) am<-Inf;
                       cm<-(b*abs(l[2])+a*abs(sum(l)))/sum(abc);if(cm>abs(l[2])) cm<-Inf;
                       c(a0=b*l[1]^2+c*sum(l)^2,b0=a*l[1]^2+c*l[2]^2,c0=b*l[2]^2+a*sum(l)^2,h13=a*am^2+b*(abs(l[1])-am)^2+c*(abs(sum(l))-am)^2,h23=c*cm^2+b*(abs(l[2])-cm)^2+a*(abs(sum(l))-cm)^2)}
bc123<-as.data.frame(t(replicate(1e3,{l<-rnorm(n=2)
                                    m<-fiven(l,abc=1:3)
                                    mm<-ddl(l,abc=1:3)
                                    c(qp=mm,m,w=which.min(m),delta=mm-min(mm))})))
plot(bc123)




ab111<-replicate(1e3,{l1<-rnorm(n=2)
                      l2<-rnorm(n=2)
                      c(ddl(l1)+ddl(l2),ddl(l1+l2)+ddl(l1-l2))})
ab123<-replicate(1e3,{l1<-rnorm(n=2)
                      l2<-rnorm(n=2)
                      c(ddl(l1,abc=1:3)+ddl(l2,abc=1:3),ddl(l1+l2,abc=1:3)+ddl(l1-l2,abc=1:3))})
#paralelogramm identity
postscript("ab111123.eps")
par(mfrow=c(1,2))
plot(t(ab111),xlab=expression(d(l[1])^2+d(l[2])^2),ylab=expression(d(l[1]+l[2])^2+d(l[1]-l[2])^2))
abline(a=0,b=2,col=2)
plot(t(ab123),xlab=expression(d(l[1])^2+d(l[2])^2),ylab=expression(d(l[1]+l[2])^2+d(l[1]-l[2])^2))
abline(a=0,b=2,col=2)
title(main="Parallelogramm Identities",outer=TRUE)
dev.off()

postscript("abx.eps")
plot(function(x)sapply(x,function(u)ddl(l=c(u,1),abc=rep(1,3))),from=-5,to=5,lwd=3,ylim=c(0,25),ylab="",main=expression({D[2]^2}(0,tau["A,B,C"]^{l*","*1})),xlab=expression(l))
plot(function(x)sapply(x,function(u)ddl(l=c(u,1),abc=1:3)),from=-5,to=5,lwd=3,col=2,add=TRUE)
plot(function(x)sapply(x,function(u)ddl(l=c(u,1),abc=c(4,1,3))),from=-5,to=5,lwd=3,col=3,add=TRUE)
legend("top",lwd=5,col=1:3,leg=c(expression({"\u0023A"==1}*", "*{"\u0023B"==1}*", "*{"\u0023C"==1}),expression({"\u0023A"==1}*", "*{"\u0023B"==2}*", "*{"\u0023C"==3}),expression({"\u0023A"==4}*", "*{"\u0023B"==1}*", "*{"\u0023C"==3})))
dev.off()

#half-integer values of D_1 on non-binary-tree-induced metrics

rdmet<-function(n=1e1,nn=1e2,c=30,nr=1e3,seed=1)
{set.seed(seed)
 ee<-  replicate(n=nr,{ab<- make_full_graph(n)
                        ab<-set_edge_attr(ab, name="weight",index=E(ab), value=sample.int(c,rep=TRUE,size=n*(n-1)/2 ))
                        d1<-distances(ab)
                        ab<-set_edge_attr(ab,  name="weight",index=E(ab), value=sample.int(c,rep=TRUE,size=n*(n-1)/2 ))
                        d2<-shortest.paths(ab)
                      gromovdist(type="l1",d1,d2)})}


a0<-rdmet(nr=1e3,c=10)
table(a0)

#non-binary trees
rdistnb<-function(n=1e3,nn=1e1,seed=1)
{set.seed(seed)
 ee<-  replicate(n=n,{gromovdist(type="l1",rtree(n=nn,br=rbinom,prob=0.5,size=1),rtree(n=nn,br=rbinom,prob=0.5,size=1))})
 return(ee)
}

a1<-rdistnb(nn=9)
table(a1)
