#include <malloc.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <Rmath.h>
#include <R.h>
#include <Rinternals.h>
#include <Rdefines.h>
#include "pottsscale.h"




/*fast version for fixed gamma-loop,
looks whether one could get better results with enlargening last interval*/

void Bellmann2D(int *l, int *jumpnum,IFTP RP,void* auxstruct, double *disttab, int *pointtab,double gamma)
{ 	int i,il,j,jl,jp,m,k,lll=*l,ll=lll-1;
	double d,dd,t;

	disttab[0] = (*RP)(0,0,auxstruct)+gamma;
	pointtab[0]=0;
	jumpnum[0]=0;
	for(j=1;j<lll;j++){
	  d = disttab[j-1]+(*RP)(j,j,auxstruct)+gamma;jp = j;
	  if ((dd = (*RP)(0,j,auxstruct)+gamma)<d){d = dd;jp = 0;};
	  for (k=j-1;k>0;k--) {if ((dd = disttab[k-1]+(t= (*RP)(k,j,auxstruct)+gamma))<d){d = dd;jp = k;} else if (dd==d) {if (jumpnum[k-1]<(jp>0?jumpnum[jp-1]:0))jp = k;} else if (t>d) break;};
/*pointtab is a row in a matrix*/
	  disttab[j] = d;pointtab[j*lll] = jp;
	  if (jp==0) jumpnum[j]=0; else jumpnum[j]=jumpnum[jp-1]+1;
	}
}
/* for later, more space needed*/
void Bellmanncyclic(int *l, int *jumpnum,IFTP RP,void* auxstruct, double *disttab, int *pointtab,double gamma)
{ 	int i,il,j,jl,jp,m,k,lll=*l,ll=lll-1;
	double d,dd,t;

	disttab[0] = (*RP)(0,0,auxstruct)+gamma;
	pointtab[0]=0;
	jumpnum[0]=0;
	for(j=1;j<lll;j++){
	  d = disttab[j-1]+(*RP)(j,j,auxstruct)+gamma;jp = j;
	  if ((dd = (*RP)(0,j,auxstruct)+gamma)<d){d = dd;jp = 0;};
	  for (k=j-1;k>0;k--) {if ((dd = disttab[k-1]+(t= (*RP)(k,j,auxstruct)+gamma))<d){d = dd;jp = k;} else if (dd==d) {if (jumpnum[k-1]<(jp>0?jumpnum[jp-1]:0))jp = k;} else if (t>d) break;};
	  disttab[j] = d;pointtab[j*lll] = jp;
	  if (jp==0) jumpnum[j]=0; else jumpnum[j]=jumpnum[jp-1]+1;
	}
}

/*shooting loop is here*/
void table2jumps_shooting(int *l,IFTP RP, void* auxstruct,int *mout,int *ergjump, double *gammatab, int *jumpjumps, SFTP FP)
{  int n,nn,na,nb,nremain,i,il,j,jl,jp,m,mm,k,lll=*l,ll=lll-1,jj[*l],pointlist[*l],*pointtab,left,right,rright,remain[lll];
  double h,s,gammalist[lll],gamma,disttabmin[lll],hh;
/*printf("a\n");*/
pointtab=(int *)malloc(sizeof(*pointtab)*lll*lll);

  typedef struct{ int jumps; double H; int next,prev;} listelT;
/*initialization*/
  listelT mylist[lll];
  mylist[0].prev=-1;
  mylist[0].jumps=0;
  mylist[0].H=(*RP)(0,ll,auxstruct);
  for(j=0;j<lll;j++) pointtab[0+j*lll]=0;
   mylist[0].next=1;
      mylist[1].next=-1;
      mylist[1].jumps=ll;
	hh=0.;
	 for(j=0;j<lll;j++) hh+=(*RP)(j,j,auxstruct);
      mylist[1].H=hh;
      left=0;right=1;remain[0]=1;
      mm=1;
      for(j=0;j<lll;j++) pointtab[1+j*lll]=j;
/*loop*/
      for(nremain=0;nremain > -1;left=mylist[right].prev){/*printf("loop:%d,%d\n",right,left);*/
if (mylist[left].jumps+1>=mylist[right].jumps) nremain --; else {

	  gamma=(mylist[right].H - mylist[left].H)/(mylist[left].jumps - mylist[right].jumps);
	  mm++;
/*printf("shoot: gama : %f,l/r: %d,%d\n",gamma,left,right);*/
	  (*FP)(l,jj,RP,auxstruct,(double *) disttabmin,&(pointtab[mm]), gamma);
	  if ((jj[ll]>mylist[left].jumps)&&(jj[ll]<mylist[right].jumps)){/* for(j=0;j<lll;j++) pointtab[j][jj[ll]]=pointlist[j]; */
	    remain[++nremain]=mylist[left].next=mylist[right].prev=mm;
	    mylist[mm].prev=left;
	    mylist[mm].next=right;
	    mylist[mm].jumps=jj[ll];
	    mylist[mm].H=disttabmin[ll]-(jj[ll]+1)*gamma;

	  } else {mm--;nremain --;};};
	if (nremain>=0) right=remain[nremain];};
/*  printf("l:%d\n",lll); */
/* for(j=0;j<=mm;j++)for (n=0;n<lll;n++)printf("pt[%d,%d]:%d\n",j,n,pointtab[j][n]); */
for(j=0;j<lll;j++){for (n=0;n<lll;n++){ergjump[j+n*lll]=-1;};};
  right=0;
rright=mylist[0].next;
  for (m=0;rright >-1;m++) 
    { 
gammatab[m]= ((h=(mylist[right].H-mylist[rright].H)/(mylist[rright].jumps-mylist[right].jumps))>0.?h:0.);
            jumpjumps[m]=mylist[right].jumps;
      nb=ll;
	for(nn=mylist[right].jumps-1;nn>=0;nn--){
na=pointtab[right+nb*lll];
	ergjump[nn+m*lll]=na;
	nb=na-1;
      }
     right=rright;rright=mylist[rright].next;
    } 
  gammatab[m]= 0.;
 jumpjumps[m]=mylist[right].jumps; 
nb=ll;
for(nn=mylist[right].jumps-1;nn>=0;nn--){
na=pointtab[right+nb*lll];
	ergjump[nn+m*lll]=na;
	nb=na-1;
      }
free(pointtab);
  *mout=m+1;
/*for (mm=0;mm<m+1;mm++) printf("letlt:%d(%d):%f,%d,%d\n",mm,mylist[mm].jumps,mylist[mm].H,mylist[mm].prev,mylist[mm].next);*/
}


void table2jumps_shooting_nmax(int *l,IFTP RP, void* auxstruct,int *mout,int *ergjump, double *gammatab, int *jumpjumps, SFTP FP,int nmax)
{  int n,nn,na,nb,nremain,i,il,j,jl,jp,m,mm,k,lll=*l,ll=lll-1,jj[*l],pointlist[*l],*pointtab,left,right,rright,remain[lll];
  double h,s,gammalist[lll],gamma,disttabmin[lll],hh;
printf("a\n");
pointtab=(int *)malloc(sizeof(*pointtab)*lll*lll);

  typedef struct{ int jumps; double H; int next,prev;} listelT;
/*initialization*/
  listelT mylist[lll];
  mylist[0].prev=-1;
  mylist[0].jumps=0;
  mylist[0].H=(*RP)(0,ll,auxstruct);
  for(j=0;j<lll;j++) pointtab[0+j*lll]=0;
   mylist[0].next=1;
      mylist[1].next=-1;
(*FP)(l,jj,RP,auxstruct,(double *) disttabmin,&(pointtab[1]), 0.);
      mylist[1].jumps=jj[ll];
      mylist[1].H=disttabmin[ll];
      left=0;right=1;remain[0]=1;
      mm=1;
/*loop*/
      for(nremain=0;nremain > -1;left=mylist[right].prev){printf("loop:%d,%d\n",right,left);
if (mylist[left].jumps+1>=mylist[right].jumps) nremain --; else {

	  gamma=(mylist[right].H - mylist[left].H)/(mylist[left].jumps - mylist[right].jumps);
	  mm++;
printf("shoot: gama : %f,l/r: %d,%d\n",gamma,left,right);
	  (*FP)(l,jj,RP,auxstruct,(double *) disttabmin,&(pointtab[mm]), gamma);
	  if ((jj[ll]>mylist[left].jumps)&&(jj[ll]<mylist[right].jumps)){/* for(j=0;j<lll;j++) pointtab[j][jj[ll]]=pointlist[j]; */
	    remain[++nremain]=mylist[left].next=mylist[right].prev=mm;
	    mylist[mm].prev=left;
	    mylist[mm].next=right;
	    mylist[mm].jumps=jj[ll];
	    mylist[mm].H=disttabmin[ll]-(jj[ll]+1)*gamma;

	  } else {mm--;nremain --;};};
	if (nremain>=0) right=remain[nremain];};
/*  printf("l:%d\n",lll); */
/* for(j=0;j<=mm;j++)for (n=0;n<lll;n++)printf("pt[%d,%d]:%d\n",j,n,pointtab[j][n]); */
for(j=0;j<lll;j++){for (n=0;n<lll;n++){ergjump[j+n*lll]=-1;};};
  right=0;
rright=mylist[0].next;
  for (m=0;rright >-1;m++) 
    { 
gammatab[m]= ((h=(mylist[right].H-mylist[rright].H)/(mylist[rright].jumps-mylist[right].jumps))>0.?h:0.);
            jumpjumps[m]=mylist[right].jumps;
      nb=ll;
	for(nn=mylist[right].jumps-1;nn>=0;nn--){
na=pointtab[right+nb*lll];
	ergjump[nn+m*lll]=na;
	nb=na-1;
      }
     right=rright;rright=mylist[rright].next;
    } 
  gammatab[m]= 0.;
 jumpjumps[m]=mylist[right].jumps; 
nb=ll;
for(nn=mylist[right].jumps-1;nn>=0;nn--){
na=pointtab[right+nb*lll];
	ergjump[nn+m*lll]=na;
	nb=na-1;
      }
free(pointtab);
  *mout=m+1;
/*for (mm=0;mm<m+1;mm++) printf("letlt:%d(%d):%f,%d,%d\n",mm,mylist[mm].jumps,mylist[mm].H,mylist[mm].prev,mylist[mm].next);*/
}

void Bellmann3D_jmax(int *l,IFTP RP, void* auxstruct,int *ergjump, double *gammatab, int *jumpjumps, SFTP FP,int nmax)
{ 	int i,il,j,jl,jp,m,k,lll=*l,ll=lll-1,*pointtab;
	double d,dd,*disttab;
pointtab=(int *)malloc(sizeof(*pointtab)*nmax*lll);
disttab=(double *)malloc(sizeof(*disttab)*nmax*lll);

	for (m=0;m<lll;m++){disttab[m] = (*RP)(0,m,auxstruct);}
	for(j=1;j<lll;j++){
		for (m=j;m<lll;m++){d = (*RP)(j,m,auxstruct);jp = j;
			for (k=(j+1);k<m+1;k++) if ((dd = disttab[k-1+(j-1)*nmax]+(*RP)(k,m,auxstruct))<d){d = dd;jp = k;};
			disttab[m+j*nmax] = d;pointtab[m+j*nmax] = jp;
		} 
	}
free(pointtab);
free(disttab);
}

typedef  struct{int i0; void* aux; IFTP RP; } auxstruct_cyc;

double cyclik(int i, int j, void* auxstruct)
{auxstruct_cyc *hh;
hh=(auxstruct_cyc *) auxstruct;
double lik=(hh->RP)(hh.i0+i,hh.i0+j,hh.aux);
/*printf("->%f\n",lik);*/
return(lik);
}



typedef  struct{int l; double* cumsums;} auxstruct_gauss;

double gausslik(int i, int j, void* auxstruct)
{auxstruct_gauss *hh;
hh=(auxstruct_gauss *) auxstruct;
int l=hh->l;
double diff[2], lik,n=j-i+1.;
for (int ii=0;ii<2;ii++){diff[ii]=hh->cumsums[ii+2*j]-(i==0?0:hh->cumsums[ii+2*(i-1)]);};
lik=diff[2]-diff[1]*diff[1]/n;
return(lik);
}

SEXP pottsjumps_gauss(SEXP lll, SEXP auxstruct)
{int l=INTEGER(lll)[0],ll=l+1,jumpjumps[l],*ergjump,mout,i,j;
ergjump=(int *)malloc(sizeof(*ergjump)*l*l);
double gammavec[ll];
SEXP gammaR, jumpsR, jumpsmR, nscale,erg;
auxstruct_gauss auxstruct_C;
auxstruct_C.l=l;
auxstruct_C.cumsums=REAL(auxstruct);
table2jumps_shooting_nmax(&l,&gausslik,  (void*) (&auxstruct_C), &mout, ergjump, gammavec, jumpjumps, &Bellmann2D,ll);
nscale=PROTECT(allocVector(INTSXP,1));
INTEGER(nscale)[0]=mout;
jumpsR=PROTECT(allocVector(INTSXP,mout));
for(i=0;i<mout;i++) INTEGER(jumpsR)[i]=jumpjumps[i];
gammaR=PROTECT(allocVector(REALSXP,mout));
for(i=0;i<mout;i++) REAL(gammaR)[i]=gammavec[i];
jumpsmR=PROTECT(allocMatrix(INTSXP,mout,l-1));
int *pm=INTEGER(jumpsmR);
/*for(i=0;i<(mout+1)*(l+1);i++) {pm[i]=-1;};*/
for(i=0;i<mout;i++) {for(j=0;j<jumpjumps[i];j++){ pm[i+ mout*j]=ergjump[j+i*l];};};
free(ergjump);
erg=PROTECT(allocVector(VECSXP,4));
SET_VECTOR_ELT(erg, 0, nscale);
SET_VECTOR_ELT(erg, 1, gammaR);
SET_VECTOR_ELT(erg, 2, jumpsR);
SET_VECTOR_ELT(erg, 3, jumpsmR);
UNPROTECT(5);
return(erg);
}

typedef  struct{int l,m; int* cumsums;} auxstruct_mbern;

double mbernlik(int i, int j, void* auxstruct)
{auxstruct_mbern *hh;
hh=(auxstruct_mbern *) auxstruct;
int l=hh->l, m=hh->m,diff[m];
/*printf("%d-%d:",i,j);*/
for (int ii=0;ii<m;ii++){diff[ii]=hh->cumsums[l*ii+j]-(i==0?0:hh->cumsums[l*ii+i-1]);};
/*printf("(%d)%d,",ii,diff[ii]);};*/
double lik=0.,n=j-i+1.;
for (int ii=0;ii<m;ii++){lik+=(diff[ii]>0?-diff[ii]*log(diff[ii]/n):0.);};
/*printf("->%f\n",lik);*/
return(lik);
}

SEXP pottsjumps_mbern(SEXP lll,SEXP m, SEXP auxstruct)
{/*printf("1\n");*/
int l=INTEGER(lll)[0],ll=l+1,jumpjumps[l],*ergjump,mout,i,j;
ergjump=(int *)malloc(sizeof(*ergjump)*l*l);
/*printf("2\n");*/
double gammavec[ll];
/*printf("3\n");*/
SEXP gammaR, jumpsR, jumpsmR, nscale,erg;
auxstruct_mbern auxstruct_C;
auxstruct_C.l=l;
auxstruct_C.m=INTEGER(m)[0];
auxstruct_C.cumsums=INTEGER(auxstruct);
/*printf("1:\n");*/
table2jumps_shooting(&l,&mbernlik,  (void*) (&auxstruct_C), &mout, ergjump, gammavec, jumpjumps, &Bellmann2D);
/*printf("2\n");*/
nscale=PROTECT(allocVector(INTSXP,1));
INTEGER(nscale)[0]=mout;
jumpsR=PROTECT(allocVector(INTSXP,mout));
for(i=0;i<mout;i++) INTEGER(jumpsR)[i]=jumpjumps[i];
gammaR=PROTECT(allocVector(REALSXP,mout));
for(i=0;i<mout;i++) REAL(gammaR)[i]=gammavec[i];
jumpsmR=PROTECT(allocMatrix(INTSXP,mout,l-1));
int *pm=INTEGER(jumpsmR);
/*for(i=0;i<(mout+1)*(l+1);i++) {pm[i]=-1;};*/
for(i=0;i<mout;i++) {for(j=0;j<jumpjumps[i];j++){ pm[i+ mout*j]=ergjump[j+i*l];};};
free(ergjump);
erg=PROTECT(allocVector(VECSXP,4));
SET_VECTOR_ELT(erg, 0, nscale);
SET_VECTOR_ELT(erg, 1, gammaR);
SET_VECTOR_ELT(erg, 2, jumpsR);
SET_VECTOR_ELT(erg, 3, jumpsmR);
UNPROTECT(5);
return(erg);
}

double bernlik(int i, int j, void* auxstruct)
{auxstruct_mbern *hh;
hh=(auxstruct_mbern *) auxstruct;
int l=hh->l,diff;
diff=hh->cumsums[j]-(i==0?0:hh->cumsums[i-1]);
double lik,n=j-i+1.;
lik=(diff>0.?-diff*log(diff/n):0.)+(diff<n?-(n-diff)*log(1.-diff/n):0.);
return(lik);
}

SEXP pottsjumps_bern(SEXP lll, SEXP auxstruct)
{int l=INTEGER(lll)[0],ll=l+1,jumpjumps[l],*ergjump,mout,i,j;
ergjump=(int *)malloc(sizeof(*ergjump)*l*l);
double gammavec[ll];
SEXP gammaR, jumpsR, jumpsmR, nscale,erg;
auxstruct_mbern auxstruct_C;
auxstruct_C.l=l;
auxstruct_C.m=1;
auxstruct_C.cumsums=INTEGER(auxstruct);
table2jumps_shooting(&l,&bernlik,  (void*) (&auxstruct_C), &mout, ergjump, gammavec, jumpjumps, &Bellmann2D);
nscale=PROTECT(allocVector(INTSXP,1));
INTEGER(nscale)[0]=mout;
jumpsR=PROTECT(allocVector(INTSXP,mout));
for(i=0;i<mout;i++) INTEGER(jumpsR)[i]=jumpjumps[i];
gammaR=PROTECT(allocVector(REALSXP,mout));
for(i=0;i<mout;i++) REAL(gammaR)[i]=gammavec[i];
jumpsmR=PROTECT(allocMatrix(INTSXP,mout,l-1));
int *pm=INTEGER(jumpsmR);
/*for(i=0;i<(mout+1)*(l+1);i++) {pm[i]=-1;};*/
for(i=0;i<mout;i++) {for(j=0;j<jumpjumps[i];j++){ pm[i+ mout*j]=ergjump[j+i*l];};};
free(ergjump);
erg=PROTECT(allocVector(VECSXP,4));
SET_VECTOR_ELT(erg, 0, nscale);
SET_VECTOR_ELT(erg, 1, gammaR);
SET_VECTOR_ELT(erg, 2, jumpsR);
SET_VECTOR_ELT(erg, 3, jumpsmR);
UNPROTECT(5);
return(erg);
}

double multinomlik(int i, int j, void* auxstruct)
{auxstruct_mbern *hh;
hh=(auxstruct_mbern *) auxstruct;
int l=hh->l, m=hh->m,diff[m];
double lik=0.,n=0.;
/*printf("%d-%d:",i,j);*/
for (int ii=0;ii<m;ii++){diff[ii]=hh->cumsums[l*ii+j]-(i==0?0:hh->cumsums[l*ii+i-1]);
	n+=diff[ii];};
/*printf("(%d)%d,",ii,diff[ii]);};*/

for (int ii=0;ii<m;ii++){lik+=(diff[ii]>0?-diff[ii]*log(diff[ii]/n):0.);};
/*printf("->%f\n",lik);*/
return(lik);
}

SEXP pottsjumps_multinom(SEXP lll,SEXP m, SEXP auxstruct)
{/*printf("1\n");*/
int l=INTEGER(lll)[0],ll=l+1,jumpjumps[l],*ergjump,mout,i,j;
ergjump=(int *)malloc(sizeof(*ergjump)*l*l);
/*printf("2\n");*/
double gammavec[ll];
/*printf("3\n");*/
SEXP gammaR, jumpsR, jumpsmR, nscale,erg;
auxstruct_mbern auxstruct_C;
auxstruct_C.l=l;
auxstruct_C.m=INTEGER(m)[0];
auxstruct_C.cumsums=INTEGER(auxstruct);
/*printf("1:\n");*/
table2jumps_shooting(&l,&multinomlik,  (void*) (&auxstruct_C), &mout, ergjump, gammavec, jumpjumps, &Bellmann2D);
/*printf("2\n");*/
nscale=PROTECT(allocVector(INTSXP,1));
INTEGER(nscale)[0]=mout;
jumpsR=PROTECT(allocVector(INTSXP,mout));
for(i=0;i<mout;i++) INTEGER(jumpsR)[i]=jumpjumps[i];
gammaR=PROTECT(allocVector(REALSXP,mout));
for(i=0;i<mout;i++) REAL(gammaR)[i]=gammavec[i];
jumpsmR=PROTECT(allocMatrix(INTSXP,mout,l-1));
int *pm=INTEGER(jumpsmR);
/*for(i=0;i<(mout+1)*(l+1);i++) {pm[i]=-1;};*/
for(i=0;i<mout;i++) {for(j=0;j<jumpjumps[i];j++){ pm[i+ mout*j]=ergjump[j+i*l];};};
free(ergjump);
erg=PROTECT(allocVector(VECSXP,4));
SET_VECTOR_ELT(erg, 0, nscale);
SET_VECTOR_ELT(erg, 1, gammaR);
SET_VECTOR_ELT(erg, 2, jumpsR);
SET_VECTOR_ELT(erg, 3, jumpsmR);
UNPROTECT(5);
return(erg);
}

