pottsscale<-function(y=c(0),method="shoot",family="gauss",lmodel="const",interface="C",nmax=Inf,...)
{famlist<-c("gauss","doubleexp","bernoulli","mbernoulli","multinom")
 pos<-pmatch(family,famlist)
 if (is.na(pos)) stop(paste("family",family,"not implemented")) else family<-famlist[pos[1]]
 cl<-match.call()
 scale<-  do.call(paste("pottsscale",family,sep=""),list(y=y,interface=interface,nmax=nmax,...))
 scale$call<-cl
 scale$family<-family
 scale$data<-y
 class(scale)<-"pottsscale"
 return(scale)
}

pottsscaledoubleexp<-function(y=c(0),interface="C",nmax=Inf,...){
  stop("l1 case not yet implemented")
}


pottsscalegauss<-function(y=c(0),interface="C",nmax=Inf,...){
  sumstruct<-rbind(as.numeric(cumsum(y)),as.numeric(cumsum(y^2)))
  n<-length(y)
  if (interface=="R") {fenv<-parent.frame()
  ffunc<-function(ss,is){i<-is[1]+1
                         j<-is[2]+1
                         n<-(j-i+1)
                         if(i>1) h<-(ss[2,j]-ss[2,i-1]-(ss[1,j]-ss[1,i-1])^2/n) 
                         else h<-(ss[2,j]-ss[1,j]^2/n)
                         # print(c(is,h))
                         return(as.numeric(h))
  }
   tmp<-.Call("pottsjumps_sexp",n,sumstruct,ffunc,fenv, PACKAGE="tssegmentation");
  }else{tmp<-.Call("pottsjumps_gauss",n,sumstruct,PACKAGE="tssegmentation");
  }
 names(tmp)<-c("nscale","gammavec","No.jumps","jumpsafter")
  nscale<-min(nmax,tmp$nscale)
  tmp$nscale<-nscale
  njump<-tmp$No.jumps
  tmp$gammavec<-c(Inf,tmp$gammavec)
  ff<-function(jumpa){mm<-rbind(1+c(0,jumpa),c(jumpa,n))
                      h<-apply(mm,function(i)mean(y[i[1]:i[2]]),MARGIN=2)
                      stepfun(x=jumpa+0.5,y=h)
  }
  ff0<-function(...){
    n<-0
    x<-double(0)
    yleft<-yright<-mean(y)
    y<-yleft
    f<-0#arbitrary
    method<-"constant"
    rval<-function(v) yleft
    class(rval) <- c("stepfun", class(rval))
    attr(rval, "call") <- sys.call()
    rval  
  }
  tmp$segmentlist<-lapply(1:nscale,function(i){ if ((n=njump[i]) !=0) ff(tmp$jumpsafter[i,1:n]) else ff0() })
  return(tmp)
  #recoh<-NULL;
  #for(i in 1:(tmp3$m + 1)){recoh[[i]]<-list(h=tmp3$ergh[i,1:(tmp3$jumps[i]+1)],j=tmp3$ergj[i,1:(tmp3$jumps[i]+1)]+1);}
  #return(list(reco = recoh,gamma = c(Inf, 
  #                                  tmp3$gammas[1:(tmp3$m + 1)])))
}
pottsscalebernoulli<-function(y=c(0),interface="C",nmax=Inf,...){
  sumstruct<-as.integer(cumsum(y))
  n<-length(y)
  if (interface=="R") {fenv<-parent.frame()
                       ffunc<-function(ss,is){i<-is[1]+1
                                              j<-is[2]+1
                                              f<-ss[j]-(if(i>1) ss[i-1] else 0)
                                              h<- -ifelse(f>0,f*log(f/(j-i+1)),0)
                                              #print(c(is,h))
                                              return(as.numeric(h))}
                       tmp<-.Call("pottsjumps_sexp",n,sumstruct,ffunc,fenv, PACKAGE="tssegmentation");}
  else{tmp<-.Call("pottsjumps_bern",n,sumstruct,PACKAGE="tssegmentation");
  }
  names(tmp)<-c("nscale","gammavec","No.jumps","jumpsafter")
  tmp$gammavec<-c(Inf,tmp$gammavec)
  nscale<-min(nmax,tmp$nscale)
  tmp$nscale<-nscale
  njump<-tmp$No.jumps
  tmp$gammavec<-c(Inf,tmp$gammavec)
  ff<-function(jumpa){mm<-rbind(1+c(0,jumpa),c(jumpa,n))
                      h<-apply(mm,function(i)mean(y[i[1]:i[2]]),MARGIN=2)
                      stepfun(x=jumpa+0.5,y=h)
  }
  ff0<-function(...){
    n<-0
    x<-double(0)
    yleft<-yright<-mean(y)
    y<-yleft
    f<-0#arbitrary
    method<-"constant"
    rval<-function(v) yleft
    class(rval) <- c("stepfun", class(rval))
    attr(rval, "call") <- sys.call()
    rval  
  }
  tmp$segmentlist<-lapply(1:nscale,function(i){ if ((n=njump[i]) !=0) ff(tmp$jumpsafter[i,1:n]) else ff0() })
  return(tmp)
  
}

pottsscalembernoulli<-function(y=c(0),interface="C",nmax=Inf,...){
  yy<-sapply(as.factor(y),table)
  m<-length(yy[,1])
  n<-length(yy[1,])
  sumstruct<-apply(yy,MARGIN=1,cumsum)
  if (interface=="R") {fenv<-parent.frame()
                       ffunc<-function(ss,is){i<-is[1]+1
                                              j<-is[2]+1
                                              f<-ss[j,]-(if(i>1) ss[i-1,] else 0)
                                              n<- j-i+1
                                              h<- -sum(ifelse(f>0,f*log(f/n),0))
                                              #print(c(is,h))
                                              return(as.numeric(h))
                       }
                       tmp<-.Call("pottsjumps_sexp",n,sumstruct,ffunc,fenv, PACKAGE="tssegmentation");
  }
  else 
  {#print(1)
    tmp<-.Call("pottsjumps_mbern",n,m,sumstruct,PACKAGE="tssegmentation");
    #print(2)
  }
  #print(1)
  names(tmp)<-c("nscale","gammavec","No.jumps","jumpsafter")
  nscale<-min(nmax,tmp$nscale)
  tmp$nscale<-nscale
  njump<-tmp$No.jumps
  tmp$gammavec<-c(Inf,tmp$gammavec)
  ff<-function(jumpa){mm<-rbind(1+c(0,jumpa),c(jumpa,n))
                      h<-apply(mm,function(i)rowMeans(yy[,i[1]:i[2],drop=FALSE]),MARGIN=2)
                      sll<-apply(h,function(y)stepfun(x=jumpa+0.5,y=y),MARGIN=1)
                      rval<-function(v)sapply(sll,function(f) f(v))
                      class(rval) <- c("vectorstepfun", class(rval))
                      attr(rval, "call") <- sys.call()
                      rval  
  }
  ff0<-function(...){
    x<-double(0)
    n<-0
    method<-"constant"
    y<-yleft<-yright<-rowMeans(yy) 
    rval<-function(v) yleft+0*v#vectorisation
    class(rval) <- c("vectorstepfun", class(rval))
    attr(rval, "call") <- sys.call()
    rval  
  }
  tmp$segmentlist<-lapply(1:nscale,function(i){ if ((n=njump[i]) !=0) ff(tmp$jumpsafter[i,1:n]) else ff0() })
  return(tmp)
  #recoh<-NULL;
  #for(i in 1:(tmp3$m + 1)){recoh[[i]]<-list(h=tmp3$ergh[i,1:(tmp3$jumps[i]+1)],j=tmp3$ergj[i,1:(tmp3$jumps[i]+1)]+1);}
  #return(list(reco = recoh,gamma = c(Inf, 
  #                                  tmp3$gammas[1:(tmp3$m + 1)])))
}

pottsscalemultinom<-function(y=c(0),interface="C",nmax=Inf,outstepfun=TRUE,...){
  z<-y
  m<-length(z[,1])
  n<-length(z[1,])
  ns<-apply(z,MARGIN=2,sum)
  sumstruct<-apply(z,MARGIN=1,cumsum)
  if (interface=="R") {fenv<-parent.frame()
                       ffunc<-function(ss,is){i<-is[1]+1
                                              j<-is[2]+1
                                              f<-ss[j,]-(if(i>1) ss[i-1,] else 0)
                                              n<- j-i+1
                                              h<- -sum(ifelse(f>0,f*log(f/n),0))
                                              #print(c(is,h))
                                              return(as.numeric(h))
                       }
                       tmp<-.Call("pottsjumps_sexp",n,sumstruct,ffunc,fenv, PACKAGE="tssegmentation");
  }
  else 
  {#print(1)
    tmp<-.Call("pottsjumps_multinom",n,m,sumstruct,PACKAGE="tssegmentation");
    #print(2)
  }
  #print("abc")
  names(tmp)<-c("nscale","gammavec","No.jumps","jumpsafter")
  nscale<-min(nmax,tmp$nscale)
  tmp$nscale<-nscale
  njump<-tmp$No.jumps
  tmp$gammavec<-c(Inf,tmp$gammavec)
  if (outstepfun){
  ff<-function(jumpa){mm<-rbind(1+c(0,jumpa),c(jumpa,n))
                      h<-apply(mm,function(i){nss<-sum(ns[i[1]:i[2]]);apply(z[,i[1]:i[2],drop=FALSE],MARGIN=1,function(u) sum(u)/nss)},MARGIN=2)
                      sll<-apply(h,function(y)stepfun(x=jumpa+0.5,y=y),MARGIN=1)
                      rval<-function(v)sapply(sll,function(f) f(v))
                      class(rval) <- c("vectorstepfun", class(rval))
                      attr(rval, "call") <- sys.call()
                      rval  
  }
  ff0<-function(...){
    x<-double(0)
    n<-0
    method<-"constant"
    y<-yleft<-yright<-apply(z,MARGIN=1,function(u) sum(u*ns)/sum(ns)) 
    rval<-function(v) yleft+0*v#vectorisation
    class(rval) <- c("vectorstepfun", class(rval))
    attr(rval, "call") <- sys.call()
    rval  
  }
  tmp$segmentlist<-lapply(1:nscale,function(i){ #print(i);
    if ((n=njump[i]) !=0) ff(tmp$jumpsafter[i,1:n]) else ff0() })}
  return(tmp)
}
