#include <malloc.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <Rmath.h>
#include <R.h>
#include <Rinternals.h>
#include <Rdefines.h>
#include "pottsscale.h"



/*fast version for fixed gamma-loop,
looks whether one could get better results with enlargening last interval*/

void Bellmann2D_sexp(int *l, int *jumpnum,IFTP_sexp RP,SEXP auxstruct,SEXP evalf,SEXP evale , double *disttab, int *pointtab,double gamma)
{ 	int i,il,j,jl,jp,m,k,lll=*l,ll=lll-1;
	double d,dd,t;

	disttab[0] = (*RP)(0,0,auxstruct, evalf,evale)+gamma;
	pointtab[0]=0;
	jumpnum[0]=0;
	for(j=1;j<lll;j++){
	  d = disttab[j-1]+(*RP)(j,j,auxstruct, evalf, evale)+gamma;jp = j;
	  if ((dd = (*RP)(0,j,auxstruct, evalf, evale)+gamma)<d){d = dd;jp = 0;};
	  for (k=j-1;k>0;k--) {if ((dd = disttab[k-1]+(t= (*RP)(k,j,auxstruct, evalf, evale)+gamma))<d){d = dd;jp = k;} else if (dd==d) {if (jumpnum[k-1]<(jp>0?jumpnum[jp-1]:0))jp = k;} else if (t>d) break;};
	  disttab[j] = d;pointtab[j] = jp;
	  if (jp==0) jumpnum[j]=0; else jumpnum[j]=jumpnum[jp-1]+1;
	}
}

/*shooting loop is here*/
void table2jumps_shooting_sexp(int *l,IFTP_sexp RP, SEXP auxstruct,SEXP evalf,SEXP evale,int *mout,int ergjump[*l][*l], double *gammatab, int *jumpjumps, SFTP_sexp FP)
{    int n,nn,na,nb,nremain,i,il,j,jl,jp,m,mm,k,lll=*l,ll=lll-1,jj[*l],pointlist[*l],pointtab[*l][*l],left,right,rright,remain[lll];
  double h,s,gammalist[lll],gamma,disttabmin[lll],hh;

  typedef struct{ int jumps; double H; int next,prev;} listelT;
/*initialization*/
  listelT mylist[lll];

  mylist[0].prev=-1;
  mylist[0].jumps=0;
  mylist[0].H=(*RP)(0,ll,auxstruct, evalf, evale);
  for(j=0;j<lll;j++) pointtab[0][j]=0;
   mylist[0].next=1;
      mylist[1].next=-1;
      mylist[1].jumps=ll;
	hh=0.;
	 for(j=0;j<lll;j++) hh+=(*RP)(j,j,auxstruct, evalf, evale);
      mylist[1].H=hh;
      left=0;right=1;remain[0]=1;
      mm=1;
      for(j=0;j<lll;j++) pointtab[1][j]=j;

/*loop*/
      for(nremain=0;nremain > -1;left=mylist[right].prev){/*printf("loop:%d,%d\n",right,left);*/
if (mylist[left].jumps+1>=mylist[right].jumps) nremain --; else {/*printf("3:%d-%d\n",left,right);*/

	  gamma=(mylist[right].H - mylist[left].H)/(mylist[left].jumps - mylist[right].jumps);
	  mm++;
/*printf("shoot: gama : %f,l/r: %d,%d\n",gamma,left,right);*/
	  (*FP)(l,jj,RP,auxstruct, evalf, evale,(double *) disttabmin,&(pointtab[mm][0]), gamma);
	  if ((jj[ll]>mylist[left].jumps)&&(jj[ll]<mylist[right].jumps)){/* for(j=0;j<lll;j++) pointtab[j][jj[ll]]=pointlist[j]; */
	    remain[++nremain]=mylist[left].next=mylist[right].prev=mm;
	    mylist[mm].prev=left;
	    mylist[mm].next=right;
	    mylist[mm].jumps=jj[ll];
	    mylist[mm].H=disttabmin[ll]-(jj[ll]+1)*gamma;

	  } else {mm--;nremain --;};};
	if (nremain>=0) right=remain[nremain];};
/*  printf("l:%d\n",lll); */
/* for(j=0;j<=mm;j++)for (n=0;n<lll;n++)printf("pt[%d,%d]:%d\n",j,n,pointtab[j][n]); */
for(j=0;j<lll;j++){for (n=0;n<lll;n++){ergjump[j][n]=-1;};};
  right=0;
rright=mylist[0].next;
  for (m=0;rright >-1;m++) 
    { 
gammatab[m]= ((h=(mylist[right].H-mylist[rright].H)/(mylist[rright].jumps-mylist[right].jumps))>0.?h:0.);
            jumpjumps[m]=mylist[right].jumps;
      nb=ll;
	for(nn=mylist[right].jumps-1;nn>=0;nn--){
na=pointtab[right][nb];
	ergjump[nn][m]=na;
	nb=na-1;
      }
     right=rright;rright=mylist[rright].next;
    } 
  gammatab[m]= 0.;
 jumpjumps[m]=mylist[right].jumps; 
nb=ll;
for(nn=mylist[right].jumps-1;nn>=0;nn--){
na=pointtab[right][nb];
	ergjump[nn][m]=na;
	nb=na-1;
      }
  *mout=m+1;
/*for (mm=0;mm<m+1;mm++) printf("letlt:%d(%d):%f,%d,%d\n",mm,mylist[mm].jumps,mylist[mm].H,mylist[mm].prev,mylist[mm].next);*/
}


double genref_sexp(int i, int j, SEXP auxstruct,SEXP evalf,SEXP evale)
{SEXP ij,ans;
ij=PROTECT(allocVector(INTSXP,2));
INTEGER(ij)[0]=i;
INTEGER(ij)[1]=j;
ans=PROTECT(allocVector(REALSXP,1));
ans=eval(lang3(evalf,auxstruct,ij),evale);
UNPROTECT(2);
return(REAL(ans)[0]);
}

SEXP pottsjumps_sexp(SEXP lll, SEXP auxstruct,SEXP evalf,SEXP evale)
{int l=INTEGER(lll)[0],ll=l+1,jumpjumps[l],ergjump[l][l],mout,i,j;
double gammavec[ll];
SEXP gammaR, jumpsR, jumpsmR, nscale,erg;
table2jumps_shooting_sexp(&l,&(genref_sexp),  auxstruct, evalf, evale, &mout, ergjump, gammavec, jumpjumps, &Bellmann2D_sexp);
nscale=PROTECT(allocVector(INTSXP,1));
INTEGER(nscale)[0]=mout;
jumpsR=PROTECT(allocVector(INTSXP,mout));
for(i=0;i<mout;i++) INTEGER(jumpsR)[i]=jumpjumps[i];
gammaR=PROTECT(allocVector(REALSXP,mout));
for(i=0;i<mout;i++) REAL(gammaR)[i]=gammavec[i];
jumpsmR=PROTECT(allocMatrix(INTSXP,mout,l-1));
int *pm=INTEGER(jumpsmR);
/*for(i=0;i<(mout+1)*(l+1);i++) {pm[i]=-1;};*/
for(i=0;i<mout;i++) {for(j=0;j<jumpjumps[i];j++){ pm[i+ mout*j]=ergjump[j][i];};};
erg=PROTECT(allocVector(VECSXP,4));
SET_VECTOR_ELT(erg, 0, nscale);
SET_VECTOR_ELT(erg, 1, gammaR);
SET_VECTOR_ELT(erg, 2, jumpsR);
SET_VECTOR_ELT(erg, 3, jumpsmR);
UNPROTECT(5);
return(erg);
}

