%% Gradientenverfahren mit Armijo-Schrittweite

function [xk,fxk] = gradientenverfahren(f,x0,tol)

    xk = x0;
    global A                                                               % um die Iterationspunkte zu plotten spter
    A(:,1) = xk;
    steps = 0;

    [~,gk,~] = unknown_3d(xk);                                             % exakten Gradienten bestimmen

    while gk*gk' > tol^2
        
        steps = steps + 1;
        dk = -gk';                                                         % Suchrichtung setzen
        tE = schrittweite_armijo(xk,dk);                                   % Armijo Schrittweite ermitteln
        xk = xk + tE*dk;                                                   % Iterationsschritt
 
        [~,gk,~] = unknown_3d(xk);                                         % exakten Gradienten bestimmen
        A(:,steps+1) = xk;
        
    end
    
    fxk = f(xk);
    steps 

end