%% Newtonverfahren mit Armijo/Powell-Schrittweite:

function [xk,fxk] = quasinewtonverfahren(f,x0,tol)

    xk = x0;
    Hk = eye(length(x0));
    steps = 0;
    global A                                                               % zur Speicherung der xk
    A = xk;
    [~,gk,~] = f(xk);                                                      % exakten Gradienten bestimmen

    while norm(gk) > tol
    
        steps = steps + 1;

        if det(Hk) ~= 0
        
            dk = (-Hk\gk');                                                % Suchrichtung setzen, falls System lsbar
            
            if gk*dk >= 0
            
                dk = -gk';                                                 % Gradienten als Richtung, falls keine Abstiegsrichtung
            
            end
            
        else
            
            dk = -gk';                                                     % Suchrichtung setzen, falls System nicht lsbar
            
        end
        
        tk = schrittweite_armijo(f,xk,dk);                                 % Armijo Schrittweite ermitteln
        %tk = schrittweite_powell(f,xk,dk);                                 % Powell Schrittweite ermitteln
        
        xkold = xk;                                                        % alte Stelle merken
        xk = xk + tk*dk;                                                   % Iterationsschritt
        
        A(:,steps+1) = xk;
        
        gkold = gk;                                                        % alten Gradienten merken
        [~,gk,~] = f(xk);                                                  % exakten Gradienten bestimmen
        
        Hk = BFGS(Hk,xk,xkold,gk,gkold);                                   % Hessematrix approximieren
        
    end
    
    fxk = f(xk);
    
    fprintf(steps + " Schritte\n");

end