%% Powell-Schrittweite bestimmen:

function tk = schrittweite_powell(f,xk,dk)
    
    delta = 0.01;
    beta = 0.5;
    tk = 1;
    stop = false;
    
    % Regel von Powell:
    
    if G1(tk,f,xk,dk,delta) <= 0 && G2(tk,f,xk,dk,beta) >= 0
        
        stop = true;
    
    elseif G1(tk,f,xk,dk,delta) <= 0 && G2(tk,f,xk,dk,beta) < 0
       
        ak = tk;
        l = 1;
        while G1((2^l)*tk,f,xk,dk,delta) < 0
            
            l = l+1;
            
        end
        
        bk = (2^l)*tk;
        
    elseif G1(tk,f,xk,dk,delta) > 0
        
        bk = tk;
        l = 1;
        while G1(2^(-l)*tk,f,xk,dk,delta) > 0 || G2(2^(-l)*tk,f,xk,dk,beta) >= 0
            
            l = l+1;
            
        end
        
        ak = 2^(-l)*tk;
        
    end
    
    % Iteration:
    if stop == false
        
        tk = (ak+bk)/2;
        
        while G1(tk,f,xk,dk,delta) > 0 || G2(tk,f,xk,dk,beta) < 0
            
            if G1(tk,f,xk,dk,delta) <= 0 && G2(tk,f,xk,dk,beta) < 0
                
                ak = tk;
            
            elseif G1(tk,f,xk,dk,delta) > 0
                
                bk = tk;
                
            end
            
            tk = (ak+bk)/2;
            
        end
        
    end

end