package algo;

import java.util.List;
import java.util.Random;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;

import graph.ColoredGraph;
import graph.ColoredGraph.Vertex;

public class VertexHighlighter implements Algorithm {
	public final static Color UNHIGHLIGHTED = Color.GREEN;
	public final static Color HIGHLIGHTED = Color.BLUE;
	
	@Override
	public String getName() {
		return "Vertex Highlighter";
	}

	@Override
	public String getDescription() {
		return "Randomly highlights a random vertex at each step";
	}

	@Override
	public List<ColoredGraph> execute(ColoredGraph inputGraph) {
		java.util.ArrayList<ColoredGraph> graphSteps = new ArrayList<>();
		ColoredGraph graph = new ColoredGraph(inputGraph);
		for (Vertex v : graph.vertexSet()) {
			v.color = UNHIGHLIGHTED;
		}
		graphSteps.add(new ColoredGraph(graph));
		
		ArrayList<Vertex> vertexList = new ArrayList<>(graph.vertexSet());
		Collections.shuffle(vertexList);
		for (Vertex v : vertexList) {
			v.color = HIGHLIGHTED;
			graphSteps.add(new ColoredGraph(graph));
		}
	
		return graphSteps;
	}

}
