package graph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;

public class ColoredGraph extends Graph<ColoredGraph.Vertex, ColoredGraph.Edge> {
	public static class Vertex {
		public Vertex() {
			color = Color.black;
			x = 0; y = 0;
		}
		
		public Vertex(Vertex v) {
			color = v.color;
			x = v.x;
			y = v.y;
		}
		
		public Color color;
		public int x, y;
	}
	
	public static class Edge {
		public Edge () {
			color = Color.black;
		}
		
		public Edge (Edge e) {
			color = e.color;
		}
		
		public Color color;
	}
	
	public ColoredGraph() {
		super();
	}
	
	public ColoredGraph(ColoredGraph graph) {
		super();
		
		HashMap<Vertex, Vertex> org2copy = new HashMap<>();
		for (Vertex v : graph.vertexSet()) {
			Vertex cv = new Vertex(v);
			this.addVertex(cv);
			org2copy.put(v, cv);
		}
		
		for (Edge e : graph.edgeSet()) {
			Edge ce = new Edge(e);
			Vertex src = org2copy.get(graph.getEdgeSource(e));
			Vertex tar = org2copy.get(graph.getEdgeTarget(e));
			this.addEdge(ce, src, tar);
		}
	}
	
	public void draw(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
	    g2.setStroke(new BasicStroke(2));
		for (Edge e : this.edgeSet()) {
			Vertex src = this.getEdgeSource(e);
			Vertex tar = this.getEdgeTarget(e);
			g.setColor(e.color);
			g2.drawLine(src.x, src.y, tar.x, tar.y);
			System.out.println("DRAWING LINE " + src.x + " " + tar.x);
		}
		
		int r = 10;
		for (Vertex v : this.vertexSet()) {
			g.setColor(v.color);
			g2.fillOval(v.x-r, v.y-r, r*2, r*2);
			g.setColor(Color.WHITE);
			String id = String.valueOf(this.getVertexId(v));
			g.drawString(id, v.x - 3, v.y + 3);
		}
	}
	
}
