package algo;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import graph.ColoredGraph;
import graph.ColoredGraph.Edge;

public class EdgeHighlighter implements Algorithm {
	public final static Color UNHIGHLIGHTED = Color.GREEN;
	public final static Color HIGHLIGHTED = Color.BLUE;
	
	@Override
	public String getName() {
		return "Edge Highlighter";
	}

	@Override
	public String getDescription() {
		return "Randomly highlights a random edge at each step";
	}

	@Override
	public List<ColoredGraph> execute(ColoredGraph inputGraph) {
		java.util.ArrayList<ColoredGraph> graphSteps = new ArrayList<>();
		ColoredGraph graph = new ColoredGraph(inputGraph);
		for (Edge e : graph.edgeSet()) {
			e.color = UNHIGHLIGHTED;
		}
		graphSteps.add(new ColoredGraph(graph));
		
		ArrayList<Edge> edgeList = new ArrayList<>(graph.edgeSet());
		Collections.shuffle(edgeList);
		for (Edge e : edgeList) {
			e.color = HIGHLIGHTED;
			graphSteps.add(new ColoredGraph(graph));
		}
	
		return graphSteps;
	}

}
