package test.algo;

import graph.ColoredGraph;
import graph.ColoredGraph.Vertex;

import java.util.List;

import algo.VertexHighlighter;
import junit.framework.TestCase;

public class TestVertexHighlighter extends TestCase {
	
	public void testEmpty() {
		ColoredGraph graph = new ColoredGraph();
		VertexHighlighter alg = new VertexHighlighter();
		List<ColoredGraph> stepList = alg.execute(graph);
		assertNotNull(stepList);
		assertEquals("Should only contain the inital step for an empty graph.", stepList.size(), 1);
		assertEquals("Init step graphs should be same as input graph", stepList.get(0).vertexSet().size(), 0);
	}
	
	public void testSimple() {
		ColoredGraph graph = new ColoredGraph();
		Vertex v1 = new Vertex();
		v1.x = 50;
		v1.y = 50;
		graph.addVertex(v1);
		
		Vertex v2 = new Vertex();
		v2.x = 100;
		v2.y = 50;
		graph.addVertex(v2);
		
		Vertex v3 = new Vertex();
		v3.x = 50;
		v3.y = 100;
		graph.addVertex(v3);
		
		Vertex v4 = new Vertex();
		v4.x = 100;
		v4.y = 100;
		graph.addVertex(v4);
		
		VertexHighlighter alg = new VertexHighlighter();
		List<ColoredGraph> stepList = alg.execute(graph);
		
		assertNotNull(stepList);
		assertEquals("Must have as many steps as there are vertices.", stepList.size(), graph.vertexSet().size() + 1);
		
		int i = 0;
		for (ColoredGraph sg : stepList) {
			int numHighlighted = 0;
			for (Vertex v : sg.vertexSet()) {
				if (v.color == VertexHighlighter.HIGHLIGHTED) {
					numHighlighted += 1;
				}
			}
			assertEquals("Must have highlighted as many vertices as steps taken", i, numHighlighted);
			i += 1;
		}
	}

}
