package ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import algo.Algorithm;
import algo.VertexHighlighter;
import graph.ColoredGraph;

public class AlgoPanel extends JPanel {
	Algorithm alg;
	List<ColoredGraph> stepList;
	int currentStep;
	JLabel lblName;
	//JLabel lblDesc;
	
	AlgoPanel() {
		super();
		this.setBorder(BorderFactory.createLineBorder(Color.black, 2, false));
		lblName = new JLabel("", JLabel.LEFT);
		//lblDesc = new JLabel("", JLabel.LEFT);
		
		alg = null;
		stepList = null;
		currentStep = 0;
		this.setVisible(true);
		
		JButton btnForward = new JButton("Forward");
		btnForward.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				stepForward();
			}
		});

		JButton btnBackward = new JButton("Backward");
		btnBackward.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				stepBackward();
			}
		});
		this.setLayout(new BorderLayout());
		JPanel btnPanel = new JPanel();
		btnPanel.add(btnBackward);
		btnPanel.add(btnForward);
		this.add(btnPanel, BorderLayout.NORTH);
		

		this.add(lblName, BorderLayout.SOUTH);
		//JPanel lblPanel = new JPanel();
		//BoxLayout lblLayout = new BoxLayout(lblPanel, BoxLayout.Y_AXIS);
		//lblPanel.setLayout(lblLayout);;
		//lblPanel.add(lblName);
		//lblPanel.add(lblDesc);
		//lblPanel.setMaximumSize(new Dimension(100, 500));
		//this.add(lblPanel, BorderLayout.EAST);
	}
	
	void stepForward() {
		if (currentStep < stepList.size()-1) {
			currentStep += 1;
			repaint();
		}
	}
	
	void stepBackward() {
		if (currentStep > 0) {
			currentStep -= 1;
			repaint();
		}
	}
	
	void switchAlgorithm(ColoredGraph graph, Algorithm alg) {
		this.alg = alg;
		this.stepList = alg.execute(graph);
		this.currentStep = 0;
		
		lblName.setText(
				"<html>" +
				"<div style=\"width:400px; margin-bottom: 10px; margin-left: 10px\">"+
				"<h2>" + alg.getName() + "</h2>" +
				alg.getDescription() +
				"</div></html>"
				);
		//lblDesc.setText("<html><div style=\"width:50px\">" + 
		//alg.getDescription() + 
		//"</div></html>");
	}
	
	@Override
    protected void paintComponent (Graphics g) {
		assert(alg != null && stepList != null);
		super.paintComponent(g);
		
		stepList.get(currentStep).draw(g);
	}
}
