package ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import graph.ColoredGraph;
import graph.ColoredGraph.Edge;
import graph.ColoredGraph.Vertex;

public class GraphPanel extends JPanel {
	ColoredGraph graph;
	private JLabel lblMouseCoords;
	
	void initGraph() {
		Vertex v1 = new Vertex();
		v1.x = 50;
		v1.y = 50;
		graph.addVertex(v1);
		
		Vertex v2 = new Vertex();
		v2.x = 100;
		v2.y = 50;
		graph.addVertex(v2);
		
		Vertex v3 = new Vertex();
		v3.x = 50;
		v3.y = 100;
		graph.addVertex(v3);
		
		Vertex v4 = new Vertex();
		v4.x = 100;
		v4.y = 100;
		graph.addVertex(v4);
		
		addEdge(0, 1);
		addEdge(2, 3);
	}
	
	GraphPanel() {
		super();
		
		graph = new ColoredGraph();
		initGraph();
		
		this.setBorder(BorderFactory.createLineBorder(Color.black, 2, false));
		
		JPanel buttonPanel = new JPanel();
		JButton btn = new JButton("Add Line");
		btn.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				createAddEdgeFrame();			
			}
		});
		buttonPanel.add(btn);
		this.add(buttonPanel, BorderLayout.WEST);
		
		this.addMouseMotionListener(new MouseMotionListener() {

			@Override
			public void mouseDragged(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mouseMoved(MouseEvent e) {
				lblMouseCoords.setText("coords: (" + e.getX() + ", " + e.getY() + ")");
				lblMouseCoords.repaint();
			}
			
		});
		
		lblMouseCoords = new JLabel("");
		this.add(lblMouseCoords, BorderLayout.NORTH);
		
		this.addMouseListener(new MouseAdapter() {
        //    private Color background;

            @Override
            public void mousePressed(MouseEvent e) {
            	ColoredGraph.Vertex v = new ColoredGraph.Vertex();
            	v.x = e.getX();
            	v.y = e.getY();
            	graph.addVertex(v);
            	repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
	}
	
	public ColoredGraph getGraph() {
		return graph;
	}
	
	private void addEdge(int vid1, int vid2) {
		Vertex src = graph.getVertexById(vid1);
		Vertex tar = graph.getVertexById(vid2);
		Edge edata = new Edge();
		graph.addEdge(edata, src, tar);
		this.repaint();
	}
	
	public void createAddEdgeFrame() {
		final JFrame frame = new JFrame();
		frame.setLayout(new FlowLayout());
		
		final JTextField txtC1 = new JTextField(1);
		final JTextField txtC2 = new JTextField(1);
		
		JButton btnCancel = new JButton("cancel");
		btnCancel.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				frame.dispose();
			}
		});
		
		JButton btnAddLine = new JButton("add");
		btnAddLine.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				int cid1 = Integer.parseInt(txtC1.getText());
				int cid2 = Integer.parseInt(txtC2.getText());
				addEdge(cid1, cid2);
				frame.dispose();
			}
		});
		
		frame.add(txtC1);
		frame.add(txtC2);
		frame.add(btnCancel);
		frame.add(btnAddLine);
		frame.setSize(300, 200);
		frame.setVisible(true);
	}
	
	@Override
    protected void paintComponent (Graphics g) {
		super.paintComponent(g);
		
		graph.draw(g);
	}
}
