package ui;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import algo.EdgeHighlighter;
import algo.VertexHighlighter;
import graph.ColoredGraph;

public class VisuGUI {
	public static void main(String[] args) {
		JFrame frame = new JFrame("GraphGUI");
		frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setSize(600, 600);
        
        frame.setLayout(new BorderLayout(5, 5));
        
		
		GraphPanel graphPanel = new GraphPanel();
		frame.add(graphPanel);
		
		AlgoPanel algoPanel = new AlgoPanel();

		
		JPanel buttonPanel = new JPanel();
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		BoxLayout btnLayout = new BoxLayout(buttonPanel, BoxLayout.Y_AXIS);
		buttonPanel.setLayout(btnLayout);
		
		JButton btnRunAlgortihm = new JButton("Run VHighlight");
		buttonPanel.add(btnRunAlgortihm);
		buttonPanel.add(Box.createVerticalStrut(10));
		JButton btnRunEHighlight = new JButton("Run EHighlight");
		buttonPanel.add(btnRunEHighlight);
		buttonPanel.add(Box.createVerticalStrut(10));
		
		
		JButton btnCreateGraph = new JButton("Create Graph");
		buttonPanel.add(btnCreateGraph);
		
		
		frame.add(buttonPanel, BorderLayout.WEST);
		
		btnRunAlgortihm.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				ColoredGraph graph = graphPanel.getGraph();
				algoPanel.switchAlgorithm(graph, new VertexHighlighter());
				frame.remove(graphPanel);
				frame.add(algoPanel);
				//frame.setContentPane(algoPanel);
				frame.revalidate();
				frame.repaint();
			}
		});
		
		btnRunEHighlight.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				ColoredGraph graph = graphPanel.getGraph();
				algoPanel.switchAlgorithm(graph, new EdgeHighlighter());
				frame.remove(graphPanel);
				frame.add(algoPanel);
				//frame.setContentPane(algoPanel);
				frame.revalidate();
				frame.repaint();
			}
		});
		
		btnCreateGraph.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				frame.remove(algoPanel);
				frame.add(graphPanel);
				//frame.setContentPane(algoPanel);
				frame.revalidate();
				frame.repaint();
			}
		});
		
		
		
		frame.setVisible(true);
	}
}
