package algo;
import java.util.List;

import graph.ColoredGraph;;

/*
 * The interface representing the base concept of an algorithm. 
 * In this case, an algorithm is a class that takes an input graph,
 * and returns a series of operations performed on the graph.
 * Here, the sequence of operations are represented by a list of ColoredGraphs.
 * 
 * Note: All implementations of algorithms must extend this abstract class. 
 * 
 * @see ColoredGraph
 */
public interface Algorithm {
	String getName();
	String getDescription();
	List<ColoredGraph> execute(ColoredGraph graph);
}
