import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MainGUI {
	
	private static DrawPanel drawPanel;
	
	public static void initGUI() {
		JFrame frame = new JFrame("GraphGUI");
		frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setSize(600, 600);
        frame.setLayout(new BorderLayout(5, 5));
        
        drawPanel = new DrawPanel();
		frame.add(drawPanel);
		
		JPanel buttonPane = new JPanel();
		JButton btn = new JButton("Add Line");
		btn.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				createAddLineFrame();			
			}
		});
		buttonPane.add(btn);
		frame.add(buttonPane, BorderLayout.WEST);
        
        frame.setVisible(true);
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {  //Note 1
            public void run() {
                initGUI();
            }
        });
	}
	
	public static void createAddLineFrame() {
		JFrame frame = new JFrame();
		frame.setLayout(new FlowLayout());
		
		JTextField txtC1 = new JTextField(1);
		JTextField txtC2 = new JTextField(1);
		
		JButton btnCancel = new JButton("cancel");
		btnCancel.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				frame.dispose();
			}
		});
		
		JButton btnAddLine = new JButton("add");
		btnAddLine.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				int cid1 = Integer.parseInt(txtC1.getText());
				int cid2 = Integer.parseInt(txtC2.getText());
				drawPanel.addLine(cid1, cid2);
				frame.dispose();
			}
		});
		
		frame.add(txtC1);
		frame.add(txtC2);
		frame.add(btnCancel);
		frame.add(btnAddLine);
		frame.setVisible(true);
	}
}
