postscript("binaerwachs.eps")
plot(1:15,2^(1:15),xlab=expression(n),ylab=expression(M[n]))
dev.off()

postscript("linearwachs.eps")
plot(1:15,10+2*(1:15),ylim=c(0,40),xlab=expression(t),ylab=expression(N[t]))
dev.off()



plotlinexp <- function(n=100,r=1.1,b=1,init=1,...){
x <- 0:(n-1)
yl <- init+b*x
yexp <- init*r^x
plot(x,pmax(yl,yexp),typ="n",xlab="Generationen",ylab="Populationsgröße",...)
lines(x,yl)
lines(x,yexp)
}
par(lwd=2)
plotlinexp(main=expression(r==1.1))
plotlinexp(n=1e3,r=1.01,main=expression(r==1.01))

postscript("linexp11.eps")
par(lwd=2)
plotlinexp(main=expression(r==1.1))
dev.off()
postscript("linexp101short.eps")
par(lwd=2)
plotlinexp(n=1e2,r=1.01,main=expression(r==1.01))
dev.off()
postscript("linexp101long.eps")
par(lwd=2)
plotlinexp(n=1e3,r=1.01,main=expression(r==1.01))
dev.off()
uspop <- read.table("/home/liebscher/TeX/vorlesung/Modellierung/uspop.dat",head=T)
attach(uspop)
plot(uspop)
plot(year,log(population))
fit1 <- lm(log(population)~year)
lines(year,fit1$fitted.values,col="red")
lll <- length(population)
dpopulation <- diff(population)
spopulation <- population[1:(lll-1)]
plot(spopulation,dpopulation/spopulation,ylim=c(0,0.4),log="x",main="Wachstumsraten Bevölkerung der USA, 1790-1990, logarithmisch",xlab="Bevölkerung (log)",ylab="Wachstumsrate")
fit2 <- lm(dpopulation/spopulation~log(spopulation))
lines(spopulation,fit2$fitted.values,col="red")


postscript("uspop.eps")
par(lwd=2)
plot(year,population,main="Bevölkerung der USA, 1790-1990",xlab="Jahr",ylab="Bevölkerung")
dev.off()
postscript("uspoplog.eps")
par(lwd=2)
plot(year,log(population),main="Bevölkerung der USA, 1790-1990,logarithmisch",xlab="Jahr",ylab="Bevölkerung (log)")
lines(year,fit1$fitted.values,col="red")
dev.off()
postscript("uspoprates.eps")
par(lwd=2)
plot(spopulation,dpopulation/spopulation,ylim=c(0,0.4),log="x",main="Wachstumsraten Bevölkerung der USA, 1790-1990, logarithmisch",xlab="Bevölkerung (log)",ylab="Wachstumsrate")
fit2 <- lm(dpopulation/spopulation~log(spopulation))
lines(spopulation,fit2$fitted.values,col="red")
dev.off()

samplebranch <- function(probs=rep(0.5,2),childs=c(0,2),n=20,init=1){
  x <- 0:(n-1)
  Mi <- 0*childs
  x[1] <- init 
  for (t in 1:(n-1)){
    Ms <- (M <- x[t])
for (i in 1:(length(probs)-1)){
                             Mi[i] <- rbinom(n=1,size=Ms,prob=probs[i])
                             Ms <- Ms-Mi[i]
  }
    Mi[length(probs)] <- M-sum(Mi[1:(length(probs)-1)])
    x[t+1] <- sum(Mi*childs)
  }
  return(x)
}

set.seed(1)
i <- 5
m <- NULL
for (k in 1:20){i <- sum(sample(size=i,x=c(0,2,4),prob=c(0.4,0.4,0.2),rep=T));m[[k]] <-i }



plotsamplebranch <- function(probs=rep(0.5,2),childs=c(0,2),n=20,init=1,repeats=10,...){
  xyy <- matrix(0,nr=repeats,nc=n)
for (j in 1:repeats){
xyy[j,] <- samplebranch(probs=probs,childs=childs,n=n,init=init)}
plot(c(apply(xyy,M=2,FUN=max),0),type="n",xlab="Generationen",ylab="Populationsgröße",...)
  for (j in 1:repeats){lines(xyy[j,],col=j)}
}
postscript("branchstrong.eps")
par(lwd=2)
plotsamplebranch(rep=20,probs=c(0.1,0.9),main="Verzweigungsprozesse mit Mittlerer Rate 1.8")
dev.off()
postscript("branchweak.eps")
par(lwd=2)
plotsamplebranch(rep=40,probs=c(0.405,0.505),main="Verzweigungsprozesse mit Mittlerer Rate 1.01",n=10,init=10)
dev.off()

xyz <- samplebranch(probs=c(0.4,0.6),childs=c(0,2),n=20,init=1)
plot(log(xyz),ylab=expression(log(N)),xlab=expression(t), main="Verzweigungsprozeß mit Mittlerer Rate 1.2")
lm1 <- lm(log(xyz)~I(1:20))
abline(a=coef(lm1)[1],b=coef(lm1)[2],col="red")
postscript("branchlogarithm1.eps")
par(lwd=2)
plot(log(xyz),ylab=expression(log(N)),xlab=expression(t), main="Verzweigungsprozeß mit Mittlerer Rate 1.2")
dev.off()
postscript("branchlogarithm2.eps")
par(lwd=2)
plot(log(xyz),ylab=expression(log(N)),xlab=expression(t), main="Verzweigungsprozeß mit Mittlerer Rate 1.2")
abline(a=coef(lm1)[1],b=coef(lm1)[2],col="red")
dev.off()

library("simecol")	#wir laden das package

linearrows <- function(m,...){n <- length(m[,1]);arrows(x0=m[1:n-1,1],x1=m[2:n,1],y0=m[1:n-1,2],y1=m[2:n,2],...)}
norm <- function(a){ifelse((sum(a*a)==0),0,1/sqrt(sum(a*a)))*a}

logistic <- new("odeModel",
             times=c(from=0,to=20,by=1),
             parms=c(r=1,K=1),
             solver="iteration",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {  with(as.list(c(parms,init)),{
               dN <- r*N*(1-N/K)
               c(N=dN)}
                      )
               },
             init=c(N=0.3)
             )
times(logistic) <-c(from=1,to=40,by=1)


plot(t(sapply(out(sim(logistic)),function(nnn) nnn)))
 par(mfrow=c(3,2))
postscript("logisticts.eps")
 par(mfrow=c(3,2))
for(ss  in c(-0.5,0.5,1.5,2.3,2.6,2.8)+1){
  init(logistic) <- c(N=0.3)
  parms(logistic) <- c(r=ss)
  uuu <- out(sim(logistic))[,"N"]
  uuu[1] <- init(logistic)
  par(lwd=2)
plot(uuu,ylim=c(0,1),xlab=expression(t),ylab=expression(N[t]),main=substitute(r==s,list(s=ss)),type="l")
  init(logistic) <- c(N=0.9)
  uuu <- out(sim(logistic))[,"N"]
  uuu[1] <- init(logistic)
  par(lwd=1)
lines(uuu,col="red")
}
dev.off()


  init(logistic) <- c(N=0.92)
  parms(logistic) <- c(r=3.2,K=1)
  uuu <- out(sim(logistic))[,"N"]
  uuu[1] <- init(logistic)
myinit <- list(N=seq(0,1,by=0.005))
plot(myinit[[1]],logistic@main(0,myinit,logistic@parms),ylim=c(0,1),type="l")
for (i in 1:15+1){arrows(x0=c(uuu[i-1],uuu[i]),x1=c(uuu[i],uuu[i]),y0=c(uuu[i],uuu[i]),y1=c(uuu[i],uuu[i+1]))}
abline(a=0,b=1,col="red")


sprucebudworm <- new("odeModel",
             times=c(from=0,to=20,by=1),
          parms=c(r0=2,K=1,A=1,B=1),
             solver="iteration",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {  with(as.list(c(parms,init)),{
               dN <- r0*N*(1-N/K-A*N/(B+N^2))
               c(N=dN)}
                      )
               },
             init=c(N=1)
          )
parms(sprucebudworm) <- c(K=10)

init(sprucebudworm) <- c(N=1)
vvv <- out(sim(sprucebudworm))[,"N"]
  vvv[1] <- init(sprucebudworm)
  par(lwd=2)
plot(vvv,ylim=c(0,12))
init(sprucebudworm) <- c(N=.10)
vvv <- out(sim(sprucebudworm))[,"N"]
  vvv[1] <- init(sprucebudworm)
  par(lwd=2)
points(vvv,col=2)

init(sprucebudworm) <- c(N=7)
vvv <- out(sim(sprucebudworm))[,"N"]
  vvv[1] <- init(sprucebudworm)
  par(lwd=2)
points(vvv,col=3)
init(sprucebudworm) <- c(N=12)
vvv <- out(sim(sprucebudworm))[,"N"]
  vvv[1] <- init(sprucebudworm)
  par(lwd=2)
points(vvv,col=4)

parms(sprucebudworm) <- c(r0=3.5,K=25,A=3,B=3)
myinit <- list(N=seq(0,10,by=0.01))
plot(myinit[[1]],sprucebudworm@main(0,myinit,sprucebudworm@parms)-myinit[[1]],type="l")

postscript("sprucebudwormts.eps")
par(mfrow=c(3,2))
times(sprucebudworm) <- c(to=20)
for(ss  in c(0.9,3,4.23,5,6.25,7)){
  init(sprucebudworm) <- c(N=0.3)
  parms(sprucebudworm) <- c(r0=ss,K=25,A=3,B=3)
   uuu <- (out(sim(sprucebudworm)))[,"N"]
  uuu[1] <- init(sprucebudworm)
  init(sprucebudworm) <- c(N=2.9)
  vvv <- (out(sim(sprucebudworm)))[,"N"]
  vvv[1] <- init(sprucebudworm)
  init(sprucebudworm) <- c(N=5.2)
  www <- (out(sim(sprucebudworm)))[,"N"]
  www[1] <- init(sprucebudworm)
  init(sprucebudworm) <- c(N=9.5)
  xxx <- (out(sim(sprucebudworm)))[,"N"]
  xxx[1] <- init(sprucebudworm)
  par(lwd=2)
plot(as.vector(uuu),ylim=c(0,max(c(uuu,vvv,www,xxx))),xlab=expression(t),ylab=expression(N[t]),main=substitute(paste("Fichtenknospenspinner-Modell mit r=",s),list(s=ss)),type="l")
  par(lwd=1)
lines(vvv,col="red")
lines(www,col="blue")
lines(xxx,col="green")
}
dev.off()

logisticc <- new("odeModel",
             times=c(from=0,to=20,by=1),
             parms=c(r=1,K=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {  with(as.list(c(parms,init)),{
               dN <- r*N*(1-N/K)
               return(list(c(dN)))}
                      )
               },
             init=c(N=0.3)
             )
times(logisticc) <-c(from=1,to=17,by=.1)
init(logisticc) <-c(N=0.01)
plot(out(sim(logisticc)),xlab=expression(t),ylab=expression(N(t)),type="l")


postscript("logisticcurve.eps")
par(lwd=2)
plot(out(sim(logisticc)),xlab=expression(t),ylab=expression(N(t)),type="l")
dev.off()
main(logisticc) <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {  with(as.list(c(parms,init)),{
               dN <- r*N*exp(-N/K)
               return(list(c(dN)))}
                      )
               }
times(logisticc) <-c(from=1,to=40,by=.1)
init(logisticc) <-c(N=0.01)
plot(out(sim(logisticc)),xlab=expression(t),ylab=expression(N(t)),type="l")


postscript("rickercurve.eps")
par(lwd=2)
plot(out(sim(logisticc)),xlab=expression(t),ylab=expression(N(t)),type="l")
dev.off()





cobweb <- function(n=1,a=0,b=1,u0=(a+b)/2,f=function(u,r=3) r*(1-u)*u,colx=2,colf=1,colw=3,main=NULL,xlab=expression(x),ylab=expression(f(x)),lww=NULL,lwn=NULL,arrowp=FALSE,alen=0.25,...)
  {x <- seq(a,b,len=1e4)
    plot(x=x,y=x,xlim=c(a,b),ylim=range(f(x,...)),col=colx,type="l",main=main,xlab=xlab,ylab=ylab,lwd=lwn)
   lines(x=x,y=f(x,...),col=colf,lwd=lwn)
   x0 <- u0
   y0 <- min(f(x,...))
   for(i in 1:n)
     {lines(c(x0,x0,f(x0,...)),c(y0,f(x0,...),f(x0,...)),col=rep(colw,n)[i],lwd=lww)
      if ( arrowp) arrows(x1=c(x0,f(x0,...)),y1=c(f(x0,...),f(x0,...)),x0=c(x0,x0),y0=c(y0,f(x0,...)),col=rep(colw,n)[i],len=alen) 
      x0 <- f(x0,...)
      y0 <- x0
     }
  }

cobweb()

cobweb(n=17)
cobweb(n=17,main=expression("logistisches Spinnennetz mit "*{r==3}*" und "*{K==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]))
cobweb(n=17,u0=0.1,main=expression("logistisches Spinnennetz mit "*{r==3}*" und "*{K==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]))
  
cobweb(n=17,u0=0.1,main=expression("logistisches Spinnennetz mit "*{r==3.8}*" und "*{K==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),r=3.8)
cobweb(n=34,u0=0.1,main=expression("logistisches Spinnennetz mit "*{r==3.8}*" und "*{tilde(K)==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),r=3.8,colw=hsv(seq(0.6,0.95,len=34)),arrowp=T,alen=0.1)

postscript(file="logisticcob1.eps")
cobweb(n=17,u0=0.1,main=expression("logistisches Spinnennetz mit "*{r[0]==2.5}*" und "*{tilde(K)==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),arrowp=T,alen=.12,r=2.5)
dev.off()

postscript(file="logisticcob2.eps")
cobweb(n=16,u0=0.1,main=expression("logistisches Spinnennetz mit "*{r[0]==3.4}*" und "*{tilde(K)==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),arrowp=T,alen=.12,r=3.4)
dev.off()

postscript(file="logisticcob3.eps")
cobweb(n=31,u0=0.1,main=expression("logistisches Spinnennetz mit "*{r[0]==3.45}*" und "*{tilde(K)==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),arrowp=T,alen=.12,r=3.45)
dev.off()

postscript(file="logisticcob4.eps")
cobweb(n=31,u0=0.1,main=expression("logistisches Spinnennetz mit "*{r[0]==3.6}*" und "*{tilde(K)==1}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),arrowp=T,alen=.12,r=3.6)
dev.off()



postscript(file="linearcob1.eps")
cobweb(n=7,b=2,u0=0.95,main=expression("lineares Spinnennetz mit "*{f*minute==2}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),f=function(u)2*u-1,arrowp=T,alen=.12) 
dev.off()

postscript(file="linearcob2.eps")
cobweb(n=5,b=2,u0=0.05,main=expression("lineares Spinnennetz mit "*{f*minute==0.5}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),f=function(u)u/2+.5,arrowp=T,alen=.12) 
dev.off()

postscript(file="linearcob3.eps")
cobweb(n=6,b=2,u0=0.05,main=expression("lineares Spinnennetz mit "*{f*minute==-0.5}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),f=function(u)-u/2+1.5,arrowp=T,alen=.12)
dev.off()

postscript(file="linearcob4.eps")
cobweb(n=10,b=2,u0=0.98,main=expression("lineares Spinnennetz mit "*{f*minute==-1.5}),lwn=2,xlab=expression(N[t]),ylab=expression(N[t+1]),f=function(u)-1.5*u+2.5,arrowp=T,alen=.12)
dev.off()


myr <- seq(0,4,length=2001)
logist<-function(u,r,K=1){r*u*(1-u/K)}
v<-rep(0.1,2001)
for (i in 1:1000){v<-logist(v,r=myr)}
w <- matrix(0,nc=1000,nr=length(myr))
w[,1] <- v
for (i in 2:1000){w[,i]<-logist(w[,i-1],r=myr)}
postscript(file="feigenbaum1.eps")
plot(type="n",x=c(0,4),y=c(0,1),main="Bifurkationsdiagramm der logistischen Gleichung",xlab=expression(r[0]),ylab="Grenzpunkte")
for (i in 1:250+750){points(myr,w[,i],pch=".",cex=2)}
dev.off()
postscript(file="feigenbaum2.eps")
plot(type="n",x=c(0,4),y=c(0,1),xlim=c(2.8,4), main="Bifurkationsdiagramm der logistischen Gleichung",xlab=expression(r[0]),ylab="Grenzpunkte")
for (i in 1:250+750){points(myr,w[,i],pch=".",cex=2)}
dev.off()

postscript(file="chaos1.eps")
plot(w[1812,1:100],type="l",lwd=2,main=substitute("Chaotische logistische Zeitreihe mit "*{r[0]==rr},list(rr=myr[1812])),xlab=expression(t),ylab=expression(N[t]))
dev.off()


postscript(file="chaos2.eps")
hist(w[1812,],main=substitute("Histogramm chaotische Zeitreihe mit "*{r[0]==rr},list(rr=myr[1812])),xlab=expression(N[t]),ylab="relative Häufigkeit in %",nclass=40,prob=T)
dev.off()



