library("simecol")	#wir laden das package
lotkavolterra<- new("odeModel",
             times=c(from=0,to=20,by=1),
             parms=c(r=1,K=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {  with(as.list(c(parms,init)),{
    dB.dt <- r1 * B-beta*B*R
    dR.dt <- -r2 * R + gamma * B*R
    list(c(dB.dt, dR.dt))
               })},
             init=c(B=1.0,R=1.0)
             
  )


init(lotkavolterra) <- c(B=0.5,R=1)
parms(lotkavolterra) <- c(r1=.5,r2=.5,beta=.5,gamma=.5)
times(lotkavolterra)<-c(to=20,by=0.02)


lvout<-out(sim(lotkavolterra))
postscript("LVsim.eps")
par(lwd=2)
plot(lvout[,"time"],pmax(lvout[,"B"],lvout[,"R"]),type="n",main=" Lotka-Volterra Räuber-Beute Modell",xlab="Zeit",ylab="Populationsdichte",ylim=c(0.5,2))
lines(lvout[,"time"],lvout[,"B"],col="red")
lines(lvout[,"time"],lvout[,"R"],col="green")
legend (0,2,c("Beute","Räuber"),col=c("red","green"),lwd=2)
dev.off()

linearrows <- function(m,...){n <- length(m[,1]);arrows(x0=m[1:n-1,1],x1=m[2:n,1],y0=m[1:n-1,2],y1=m[2:n,2],...)}
norm <- function(a){ifelse((sum(a*a)==0),0,1/sqrt(sum(a*a)))*a}

init(lotkavolterra) <- c(B=4,R=1)
lvout<-out(sim(lotkavolterra))

plot(lvout[,"B"],lvout[,"R"],xlim=c(0,max(lvout[,"B"])),ylim=c(0,max(lvout[,"R"])),type="n",main="Phasendiagramm Lotka-Volterra Räuber-Beute Modell",xlab="Beute",ylab="Räuber")
for (i in seq(0.1,1,by=.1)){init(lotkavolterra) <- c(B=i,R=1);lvout<-out(sim(lotkavolterra));linearrows(lvout[,c("B","R")])}

plot(lvout[,"B"],lvout[,"R"],xlim=c(0,4),ylim=c(0,4),type="n",main="Richtungsfeld Lotka-Volterra Räuber-Beute Modell",xlab="Beute",ylab="Räuber")
for (i in seq(0.0,4,l=40)){
for (j in seq(0.0,4,l=40)){
  z <- 0.0675*norm((main(lotkavolterra))(0.0,init=c(B=i,R=j),parms=parms(lotkavolterra))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.04)
}}
for (i in seq(0.1,1,by=.1)){init(lotkavolterra) <- c(B=i,R=1);lvout<-out(sim(lotkavolterra));lines(lvout[,c("B","R")],col="red")}

postscript("LVvectors.eps")
par(lwd=2)
plot(lvout[,"B"],lvout[,"R"],xlim=c(0,4),ylim=c(0,4),type="n",main="Richtungsfeld Lotka-Volterra Räuber-Beute Modell",xlab="Beute",ylab="Räuber")
for (i in seq(0.0,4,l=20)){
for (j in seq(0.0,4,l=20)){
  z <- 0.125*norm((main(lotkavolterra))(0.0,init=c(B=i,R=j),parms=parms(lotkavolterra))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.0675)
}}
dev.off()

postscript("LVphase.eps")
par(lwd=2)
plot(lvout[,"B"],lvout[,"R"],xlim=c(0,4),ylim=c(0,4),type="n",main="Phasendiagramm Lotka-Volterra Räuber-Beute Modell",xlab="Beute",ylab="Räuber")
for (i in seq(0.1,1,by=.1)){init(lotkavolterra) <- c(B=i,R=1);lvout<-out(sim(lotkavolterra));lines(lvout[,c("B","R")])}
dev.off()

int1 <- function(u,v) {u-log(u)+v-log(v)}
mmm <- outer(seq(0.1,3,0.1),seq(0.1,3,0.1),FUN=int1)
postscript("LVint.eps")
persp(x=seq(0.1,3,0.1),y=seq(0.1,3,0.1),mmm,shade=0.35,phi=30,theta=100,xlab="Räuber",ylab="Beute",zlab=expression(u-log(u)+v-log(v)),col=hsv(0.75))
dev.off()

lotka2 <- lotkavolterra
main(lotka2) <- function (time, init, parms, inputs = NULL) 
{
with(as.list(c(parms,init)),{
    dx1.dt <- r1 * B*(1-B/K)-beta*B*R
    dx2.dt <- -r2 * R + gamma * B*R
    list(c(dx1.dt, dx2.dt))
})
}
 parms(lotka2) <- c(r1=.5,r2=.5,K=2,beta=.5,gamma=.5)
 init(lotka2) <- c(B=0.5,R=1)
times(lotka2) <- c(to=40,by=0.1)
lvout2<-out(sim(lotka2))
postscript("Lotka2sim.eps")
par(lwd=2)
plot(lvout2[,"time"],lvout2[,"B"],ylim=c(0,max(lvout2[,c("B","R")])),type="n",main=" Lotka Räuber-Beute Modell",xlab="Zeit",ylab="Populationsdichte")
lines(lvout2[,"time"],lvout2[,"B"],col="red")
lines(lvout2[,"time"],lvout2[,"R"],col="green")
legend (0,1.2,c("Beute","Räuber"),col=c("red","green"),lwd=2)
dev.off()
times(lotka2) <- c(by=0.1)
lvout2<-out(sim(lotka2))
postscript("Lotka2simphase.eps")
par(lwd=2)
plot(lvout2[,"B"],lvout2[,"R"],type="l",main="Phasendiagramm Lotka Räuber-Beute Modell",xlab="Beute",ylab="Räuber")
for (i in seq(0.1,3,by=.2)){init(lotka2) <- c(B=i,R=1);lvout3<-out(sim(lotka2));lines(lvout3[,"B"],lvout3[,"R"])}
dev.off()

postscript("Lotka2vectors.eps")
par(lwd=2)
plot(lvout2[,"B"],lvout2[,"R"],xlim=c(0,2),ylim=c(0,1),type="n",main="Richtungsfeld Lotka Räuber-Beute Modell",xlab="Beute",ylab="Räuber")
for (i in seq(0.0,2,l=20)){
for (j in seq(0.0,1,l=20)){
  z <- 0.05*norm((main(lotka2))(0.0,init=c(B=i,R=j),parms=parms(lotka2))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.02)
}}
dev.off()

holling <- lotkavolterra
main(holling) <- function (time, init, parms, inputs = NULL) 
{
with(as.list(c(parms,init)),{
    dx1.dt <- r1 * B*(1-B/K)-beta*(B^a/(b+B^a))*R
    dx2.dt <- -r2 * R + gamma * (B^a/(b+B^a))*R
    list(c(dx1.dt, dx2.dt))
})
}
 parms(holling) <- c(r1=.5,r2=.5,K=2,beta=.5,gamma=2,a=1,b=1)
 init(holling) <- c(B=0.5,R=1)
times(holling) <- c(to=40,by=0.1)
htout2<-out(sim(holling))
postscript("hollingsim.eps")
par(lwd=2)
plot(htout2[,"time"],htout2[,"B"],ylim=c(0,max(htout2[,c("B","R")])),type="n",main="Holling-Tanner Räuber-Beute Modell",xlab="Zeit",ylab="Populationsdichte")
lines(htout2[,"time"],htout2[,"B"],col="red")
lines(htout2[,"time"],htout2[,"R"],col="green")
legend (0,1.2,c("Beute","Räuber"),col=c("red","green"),lwd=2)
dev.off()
postscript("hollingsimphase.eps")
par(lwd=2)
times(holling) <- c(to=200,by=0.1)
plot(htout2[,"B"],htout2[,"R"],type="l",main="Phasendiagramm Holling-Tanner Räuber-Beute Modell",xlim=c(0,1.5),ylim=c(0,4.5),xlab="Beute",ylab="Räuber")
for (i in c(0.1,0.5,1.5)){init(holling) <- c(B=i,R=1);lvout3<-out(sim(holling));lines(lvout3[,"B"],lvout3[,"R"],col=hsv(i/1.6))}
dev.off()

postscript("hollingvectors.eps")
par(lwd=2)
plot(htout2[,"B"],htout2[,"R"],xlim=c(0,.7),ylim=c(0,2),type="n",main="Richtungsfeld Holling-Tanner Räuber-Beute Modell",xlab="Beute",ylab="Räuber")
for (i in seq(0.0,0.7,l=30)){
for (j in seq(0.0,2,l=30)){
  z <- 0.03*norm((main(holling))(0.0,init=c(B=i,R=j),parms=parms(holling))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.05)
}}
dev.off()


nkette4 <-   new("odeModel",
             times=c(from=0,to=20,by=0.001),
             parms=c(r1=10,r2=1,r3=0.1,r4=1,b1=10,b2=1,b3=1,c2=10,c3=1,c4=1),
             solver="lsoda",
             main=function (time, init, parms, inputs = NULL) 
{
with(as.list(c(parms,init)),{
    dB.dt <- r1 * B - b1*B*C
    dC.dt <- -r2 * C + c2* B*C - b2*C*D
    dD.dt <- -r3 * D + c3* C*D - b3*D*E
    dE.dt <- -r4 * E + c4*D*E
    
    list(c(dB.dt, dC.dt, dD.dt, dE.dt))
})
},
             init=c(B=0.2,C=1,D=10,E=0.9)
             
  )

nkout <- out(sim(nkette4))
plot(nkout,panel=lines)
main(nkette4)(0,init(nkette4),parms(nkette4))

plot(nkout[,"time"],nkout[,"B"],ylim=range(c(nkout[,2:5])),type="n",main="Nahrungskette",xlab="Zeit",ylab="Populationsdichte")
for (k in 2:5) {lines(nkout[,"time"],nkout[,k],col=k)}
legend (15,5,c(expression(B),expression(R[1]),expression(R[2]),expression(R[3])),col=2:5,lwd=2)

par(mfrow=c(3,3))
for (t in seq(1,10,len=9)){
for (t in seq(7.5,9.5,len=9)){
parms(nkette4) <- c(r1=10,r2=1,r3=0.1,r4=1,b1=10,b2=5,b3=1,c2=10,c3=1,c4=1)
init(nkette4) <- c(B=1,C=1,D=1,E=0.9)
nkout <- out(sim(nkette4))

plot(nkout[,"time"],nkout[,"B"],ylim=range(c(nkout[,2:5])),type="n",main=substitute(paste("Nahrungskette mit ", beta[2] == t),list(t=t)),xlab="Zeit",ylab="Populationsdichte")
for (k in 2:5) {lines(nkout[,"time"],nkout[,k],col=k)}
#legend (40,0.5,names(nkout[1,2:5]),col=2:5,lwd=2)
}
postscript("nahrung9.eps")
par(mfrow=c(3,3))
for (t in seq(7.5,9.5,len=9)){
parms(nkette4) <- c(r1=10,r2=1,r3=0.1,r4=1,b1=10,b2=t,b3=1,c2=10,c3=1,c4=1)
init(nkette4) <- c(B=1,C=1,D=1,E=0.9)
times(nkette4) <- c(to=20)
nkout <- out(sim(nkette4))

plot(nkout[,"time"],nkout[,"B"],ylim=range(c(nkout[,2:5])),type="n",main=substitute(paste("Nahrungskette mit   ", beta[2] == t),list(t=t)),xlab="Zeit",ylab="Populationsdichte")
for (k in 2:5) {lines(nkout[,"time"],nkout[,k],col=k)}
#legend (40,0.5,names(nkout[1,2:5]),col=2:5,lwd=2)
}
dev.off()

postscript("nahrungoszillation.eps")
parms(nkette4) <- c(r1=10,r2=1,r3=0.1,r4=1,b1=10,b2=5,b3=1,c2=10,c3=1,c4=1)
times(nkette4) <- c(to=50)
init(nkette4)<-c(B=1,C=1,D=1,E=0.9)
a1 <- out(sim(nkette4))
init(nkette4)<-c(B=1,C=3,D=1,E=1.9)
a2 <- out(sim(nkette4))
init(nkette4)<-c(B=1,C=1,D=3,E=0.9)
a3 <- out(sim(nkette4))
par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=paste("Nahrungskette mit  Oszillation",paste(names(parms(nkette4)),"=",parms(nkette4),collapse=",")),labels=c(expression(t),expression(B),expression(R[1]),expression(R[2]),expression(R[3])),cex=15)
dev.off()

postscript("nahrungchaos.eps")
parms(nkette4) <- c(r1=10,r2=1,r3=0.075,r4=1,b1=10,b2=0.15,b3=1,c2=10,c3=2,c4=.2)
times(nkette4) <- c(to=100)
init(nkette4)<-c(B=1,C=3,D=1,E=3.9)
a1 <- out(sim(nkette4))
init(nkette4)<-c(B=4,C=6,D=3,E=0.9)
a2 <- out(sim(nkette4))
init(nkette4)<-c(B=1,C=1,D=6,E=0.9)
a3 <- out(sim(nkette4))
par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=paste("Nahrungskette mit  Chaos",paste(names(parms(nkette4)),"=",parms(nkette4),collapse=",")),labels=c(expression(t),expression(B),expression(R[1]),expression(R[2]),expression(R[3])),cex=15)
dev.off()



lotkaconc <- lotkavolterra
main(lotkaconc) <- function (time, init, parms, inputs = NULL) 
{
with(as.list(c(parms,init)),{
    dx1.dt <- r1*N1*(1 -(N1+alphap*N2)/K1)
    dx2.dt <- r2*N2*(1 -(N2+betap*N1)/K2)
    list(c(dx1.dt, dx2.dt))
})
  }
linearrows <- function(m,...){n <- length(m[,1]);arrows(x0=m[1:n-1,1],x1=m[2:n,1],y0=m[1:n-1,2],y1=m[2:n,2],...)}
norm <- function(a){ifelse((sum(a*a)==0),0,1/sqrt(sum(a*a)))*a}


parms(lotkaconc) <- c(r1=1,r2=2,K1=1,K2=2,alpha=1,beta=1)
init(lotkaconc) <- c(N1=0.5,N2=1)
times(lotkaconc)<-c(to=50,by=.5)

lvcout<-out(sim(lotkaconc))
plot(lvcout[,"time"],pmax(lvcout[,"N1"],lvcout[,"N2"]),type="n",main=" Lotka-Volterra Räuber-Beute Modell",xlab="Zeit",ylab="Populationsdichte",ylim=c(0,4))
lines(lvcout[,"time"],lvcout[,"N1"],col="red")
lines(lvcout[,"time"],lvcout[,"N2"],col="green")
plot(lvcout[,"N1"],lvcout[,"N2"],type="l",main="Phasendiagramm Lotka-Volterra Räuber-Beute Modell",xlab="Beute",ylab="Räuber")


parms(lotkaconc) <- c(r1=1,r2=1,K1=1,K2=.5,alphap=1,betap=1)
times(lotkaconc) <- c(to=5,by=0.2)
parms(lotkaconc) <-  c(alphap=3,betap=1/3)
parms(lotkaconc) <-  c(alphap=1,betap=1/3)
parms(lotkaconc) <-  c(alphap=3,betap=1)
init(lotkaconc) <- c(N1=parms(lotkaconc)["K1"],N2=parms(lotkaconc)["K2"])
names(init(lotkaconc)) <-c("N1","N2")
lvcout<-out(sim(lotkaconc))
par(lwd=1)
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main="Phasendiagramm Lotka Konkurenz-Modell",xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.1,1,by=.1)){with(as.list(parms(lotkaconc)),{init(lotkaconc) <- c(N1=K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=.05*K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=.05*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05)})}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alphap"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["betap"],col="green")
X11()
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main="Phasendiagramm Lotka Konkurenz-Modell",xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.0,1,by=0.05)){
for (j in seq(0.0,0.5,by=.025)){
  z <- 0.025*norm(main(lotkaconc)(0.0,init=c(N1=i,N2=j),parms=parms(lotkaconc))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)
}}

postscript("lotkaconcsim.eps")
parms(lotkaconc)<-c(r1=1,r2=1,K1=1,K2=.5,alphap=1,betap=1)
times(lotkaconc)<-c(from=0,by=0.2,to=50)
init(lotkaconc)<-c(N1=1,N2=1)
a1 <- out(sim(lotkaconc))
init(lotkaconc)<-c(N1=.01,N2=1)
a2 <- out(sim(lotkaconc))
init(lotkaconc)<-c(N1=0.5,N2=.01)
a3 <- out(sim(lotkaconc))
par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=substitute("Lotkas Konkurrenz-Modell mit "*{r[1]==r1}*{r[2]==r2}*{K[1]==K1}*{K[2]==K2}*" "*{alpha==alphap}*{beta==betap},as.list(parms(lotkaconc))),labels=c(expression(t),expression(N[1]),expression(N[2])),cex=15)
dev.off()

# anpassen!
postscript("lotkaconc11.eps")
parms(lotkaconc) <-  c(alpha=1,beta=1)
par(lwd=1)
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Phasendiagramm Lotka Konkurenz-Modell",alpha==1~~beta==1)),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.1,1,by=.1)){with(as.list(parms(lotkaconc)),{init(lotkaconc) <- c(N1=K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=.05*K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=.05*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05)})}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()
postscript("lotkaconc11VF.eps")
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Richtungsfeld Lotka Konkurenz-Modell",alpha==1,beta==1)),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.0,1,by=0.05)){
for (j in seq(0.0,0.5,by=.025)){
  z <- 0.025*norm(lotkaconc$equations(0.0,init=c(N1=i,N2=j),parms=parms(lotkaconc))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)
}}
dev.off()

postscript("lotkaconc11.eps")
parms(lotkaconc) <-  c(alpha=1,beta=1)
par(lwd=1)
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Phasendiagramm Lotka Konkurenz-Modell",alpha==1~~beta==1)),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.1,1,by=.1)){with(as.list(parms(lotkaconc)),{init(lotkaconc) <- c(N1=K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=.05*K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=.05*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05)})}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()
postscript("lotkaconc11VF.eps")
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Richtungsfeld Lotka Konkurenz-Modell",alpha==1~~beta==1)),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.0,1,by=0.05)){
for (j in seq(0.0,0.5,by=.025)){
  z <- 0.025*norm(lotkaconc$equations(0.0,init=c(N1=i,N2=j),parms=parms(lotkaconc))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)
}}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()


postscript("lotkaconc31.eps")
parms(lotkaconc) <-  c(alpha=3,beta=1)
par(lwd=1)
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Phasendiagramm Lotka Konkurenz-Modell",alpha==3~~beta==1)),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.1,1,by=.1)){with(as.list(parms(lotkaconc)),{init(lotkaconc) <- c(N1=K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=.05*K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=.05*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05)})}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()
postscript("lotkaconc31VF.eps")
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Richtungsfeld Lotka Konkurenz-Modell",alpha==3~~beta==1)),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.0,1,by=0.05)){
for (j in seq(0.0,0.5,by=.025)){
  z <- 0.025*norm(lotkaconc$equations(0.0,init=c(N1=i,N2=j),parms=parms(lotkaconc))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)
}}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()


postscript("lotkaconc33.eps")
parms(lotkaconc) <-  c(alpha=3,beta=1/3)
par(lwd=1)
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Phasendiagramm Lotka Konkurenz-Modell",alpha==3~~beta==frac(1,3))),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.1,1,by=.1)){with(as.list(parms(lotkaconc)),{init(lotkaconc) <- c(N1=K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=.05*K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=.05*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05)})}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()
postscript("lotkaconc33VF.eps")
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Richtungsfeld Lotka Konkurenz-Modell",alpha==3~~beta==frac(1,3))),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.0,1,by=0.05)){
for (j in seq(0.0,0.5,by=.025)){
  z <- 0.025*norm(lotkaconc$equations(0.0,init=c(N1=i,N2=j),parms=parms(lotkaconc))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)
}}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()


postscript("lotkaconc13.eps")
parms(lotkaconc) <-  c(alpha=1,beta=1/3)
par(lwd=1)
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Phasendiagramm Lotka Konkurenz-Modell",alpha==1~~beta==frac(1,3))),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.1,1,by=.1)){with(as.list(parms(lotkaconc)),{init(lotkaconc) <- c(N1=K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=.05*K1,N2=i*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05);init(lotkaconc) <- c(N1=i*K1,N2=.05*K2);linearrows(out(sim(lotkaconc))[,c("N1","N2")],length=0.05)})}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()
postscript("lotkaconc13VF.eps")
plot(lvcout[,"N1"],lvcout[,"N2"],type="n",main=expression(paste("Richtungsfeld Lotka Konkurenz-Modell",alpha==1~~beta==frac(1,3))),xlab="Spezies 1",ylab="Spezies 2",xlim=c(0,parms(lotkaconc)["K1"]),ylim=c(0,parms(lotkaconc)["K2"]))
for (i in seq(0.0,1,by=0.05)){
for (j in seq(0.0,0.5,by=.025)){
  z <- 0.025*norm(lotkaconc$equations(0.0,init=c(N1=i,N2=j),parms=parms(lotkaconc))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)
}}
par(lwd=2)
abline(a=parms(lotkaconc)["K1"]/parms(lotkaconc)["alpha"],b=-1/parms(lotkaconc)["alpha"],col="red")
abline(a=parms(lotkaconc)["K2"],b=-parms(lotkaconc)["beta"],col="green")
dev.off()







source("/home/liebscher/TeX/vorlesung/TheoretischeÖkologie/R/LV1st.R")
sim1 <- reactionLV1ST(n=1e5,startB=1e3,startD=0,startR=1e3,startS=0,kappa1=2,kappa3=2e-3,kappa4=0.5)
plot(sim1$t,pmax(sim1$ab[,1],sim1$ab[,3]+sim1$ab[,4]),type="n",main="Stochastisches Lotka-Volterra Räuber-Beute Modell",xlab="Zeit",ylab="Populationsdichte",ylim=c(0,max(c(sim1$ab[,1],sim1$ab[,3],sim1$ab[,4]))))
for (i in 1:3) {lines(sim1$t,sim1$ab[,c(1,3,4)[i]],col=i+1)}
legend (3,50,c("Beute","hungernder Räuber","satter Räuber"),col=2:4,lwd=2)

par(mfrow=c(3,3))
for (j in 1:9){set.seed(c(2^j-3));
sim1 <- reactionLV1ST(n=1e5,startB=1e2,startD=0,startR=3e2,startS=120,kappa1=1.2,kappa2=0.01,kappa3=4e-3,kappa4=1.25,kappa5=1,kappa6=0.5)
plot(sim1$t,pmax(sim1$ab[,1],sim1$ab[,3]+sim1$ab[,4]),type="n",main=paste(j),xlab="Zeit",ylab="Populationsdichte",ylim=c(0,max(c(sim1$ab[,1],sim1$ab[,3],sim1$ab[,4]))))
for (i in 1:3) {lines(sim1$t,sim1$ab[,c(1,3,4)[i]],col=i+1)}
legend (mean(range(sim1$t)),mean(range(sim1$ab[,c(1,3,4)])),c("Beute","hungernder Räuber","satter Räuber"),col=2:4,lwd=2)
 }               

postscript("RBstochastisch.eps")
par(mfrow=c(3,3))
for (j in 1:9){set.seed(c(2^j-3));
sim1 <- reactionLV1ST(n=1e5,startB=1e2,startD=0,startR=3e2,startS=120,kappa1=1.2,kappa2=0.01,kappa3=4e-3,kappa4=1.25,kappa5=1,kappa6=0.5)
plot(sim1$t,pmax(sim1$ab[,1],sim1$ab[,3]+sim1$ab[,4]),type="n",main=paste(j),xlab="Zeit",ylab="Populationsdichte",ylim=c(0,max(c(sim1$ab[,1],sim1$ab[,3],sim1$ab[,4]))))
for (i in 1:3) {lines(sim1$t,sim1$ab[,c(1,3,4)[i]],col=i+1)}
legend (mean(range(sim1$t)),mean(range(sim1$ab[,c(1,3,4)])),c("Beute","hungernder Räuber","satter Räuber"),col=2:4,lwd=2)
 }               
dev.off()

par(mfrow=c(3,3))
for (j in 1:9){set.seed(c(2^j-3));
sim1 <- reactionLV1ST(n=1e6,startB=1e3,startD=0,startR=3e2,startS=120,kappa1=1.2,kappa2=0.01,kappa3=4e-3,kappa4=1.25,kappa5=1,kappa6=0.5)
plot(sim1$t,pmax(sim1$ab[,1],sim1$ab[,3]+sim1$ab[,4]),type="n",main=paste(j),xlab="Zeit",ylab="Populationsdichte",ylim=c(0,max(c(sim1$ab[,1],sim1$ab[,3],sim1$ab[,4]))))
for (i in 1:3) {lines(sim1$t,sim1$ab[,c(1,3,4)[i]],col=i+1)}
legend (mean(range(sim1$t)),mean(range(sim1$ab[,c(1,3,4)])),c("Beute","hungernder Räuber","satter Räuber"),col=2:4,lwd=2)
 }

RBext <- lotkavolterra
main(RBext) <- function (time, init, parms, inputs = NULL) 
{
with(as.list(c(parms,init)),{
    dB.dt <- B*(kappa1-kappa2-kappa3*R)
    dR.dt <- -kappa3*R*B+(kappa4+kappa5)*S-kappa6*R
    dS.dt <- kappa3*R*B-kappa5*S
    list(c(dB.dt, dR.dt, dS.dt))
})
}

init(RBext) <- c(B=1e2,R=3e2,S=120)
parms(RBext) <- c(kappa1=1.2,kappa2=0.01,kappa3=4e-3,kappa4=1.25,kappa5=1,kappa6=0.5)
init(RBext) <- c(B=0.5/(4e-3*1.25),R=1.19/4e-3,S=1.19e2)
RBout <- out(sim(RBext))

plot(RBout[,"time"],RBout[,"B"],ylim=c(0,max(RBout[,2:4])),type="n",main="Erweitertes Räuber-Beute-Modell",xlab="Zeit",ylab="Populationsdichte")
for (k in 2:4) {lines(RBout[,"time"],RBout[,k],col=k)}













sss <- .Random.seed
print(sss)
print( runif(n=2))
.Random.seed<-sss
print( runif(n=2))
