library("simecol")
data(lv)
SIREndemie <- lv
linearrows <- function(m,...){n <- length(m[,1]);arrows(x0=m[1:n-1,1],x1=m[2:n,1],y0=m[1:n-1,2],y1=m[2:n,2],...)}
norm <- function(a){ifelse((sum(a*a)==0),0,1/sqrt(sum(a*a)))*a}

postscript("sigmoide.eps")
tt <- seq(-10,10,len=1e4)
plot(x=tt,y=1/(1+exp(-tt)),type="l",main=expression(paste("Sigmoide    ", f(t)==frac(1,1+exp(-t)))),xlab=expression(t),ylab=expression(f(t)))
dev.off()


SIREndemie@main <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
 { with(as.list(c(init,parms)),{
 dS.dt <- b-beta*I*S -b*S
 dI.dt <- beta*I*S -gamma*I -b*I
 dR.dt <- gamma*I -b*R
 list(c(dS.dt,dI.dt,dR.dt))})}

SIREndemie@init <- c(S=0.99,I=0.01,R=0)
SIREndemie@parms <- c(b=0.1,beta=2,gamma=1)

times(SIREndemie) <- c(to=10,by=0.02)

par(oma=rep(0,4),mar=rep(1,4));
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=20)){init(SIREndemie) <- c(S=i,I=1-i);linearrows(out(sim(SIREndemie))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SIREndemie) <- c(S=i,I=0.01);linearrows(out(sim(SIREndemie))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SIREndemie) <- c(S=0.01,I=i);linearrows(out(sim(SIREndemie))[,c("S","I")],length=.05)}

SIREndemie@parms <- c(b=3,beta=.2,gamma=1)
times(SIREndemie) <- c(to=10)

par(oma=rep(0,4),mar=rep(1,4));
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,ann=F,xla="",yla="",ax=F,frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=20)){init(SIREndemie) <- c(S=i,I=1-i);linearrows(out(sim(SIREndemie))[,c("S","I")],length=.01)}
for (i in seq(0,1,l=20)){init(SIREndemie) <- c(S=i,I=0.01);linearrows(out(sim(SIREndemie))[,c("S","I")],length=.01)}
for (i in seq(0,1,l=20)){init(SIREndemie) <- c(S=0.01,I=i);linearrows(out(sim(SIREndemie))[,c("S","I")],length=.01)}

SIREndemieimpft <- SIREndemie
SIREndemieimpft@parms <- c(b=0.1,beta=2,gamma=1,p=0.5)

plot(RBout[,"time"],RBout[,"B"],ylim=range(c(RBout[,2:4])),type="n",main="Erweitertes Räuber-Beute-Modell",xlab="Zeit",ylab="Populationsdichte")
for (k in 2:4) {lines(RBout[,"time"],RBout[,k],col=k)}

SIRepi <- SIREndemie
SIRepi@main <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
 { with(as.list(c(init,parms)),{
 dS.dt <- -beta*I*S 
 dI.dt <- beta*I*S -gamma*I 
 dR.dt <- gamma*I 
 list(c(dS.dt,dI.dt,dR.dt))})}

SIRepi@init <- c(S=0.99,I=0.01,R=0)
SIRepi@parms <- c(beta=5,gamma=1)

times(SIRepi) <- c(to=10,by=0.02)

library("simecol")	#wir laden das package
SIRepi<- new("odeModel",
             times=c(from=0,to=10,by=0.02),
             parms=c(beta=5,gamma=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             { with(as.list(c(init,parms)),{
               dS.dt <- -beta*I*S 
               dI.dt <- beta*I*S -gamma*I 
               dR.dt <- gamma*I 
               list(c(dS.dt,dI.dt,dR.dt))})},
             init=c(S=0.99,I=0.01,R=0)
             )
             



par(oma=rep(0,4),mar=rep(1,4));
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIRepi) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRepi) <- c(S=i,I=0.01,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRepi) <- c(S=0.01,I=i,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}

postscript("SIRepifieldhigh.eps")
SIRepi@parms <- c(beta=5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIR-Epidemie-Modells mit ",beta==5~gamma==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm(SIRepi@main(0.0,init=c(S=i,I=j,R=1-i-j),parms=SIRepi@parms)[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
postscript("SIRepifieldlow.eps")
SIRepi@parms <- c(beta=.5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIR-Epidemie-Modells mit ",beta==0.5~gamma==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm(SIRepi@main(0.0,init=c(S=i,I=j,R=1-i-j),parms=SIRepi@parms)[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
postscript("SIRepisimhigh.eps")
times(SIRepi) <- c(to=10,by=0.02)
SIRepi@parms <- c(beta=5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation  SIR-Epidemie-Modells mit ",beta==5~gamma==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIRepi) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRepi) <- c(S=i,I=0.01,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
#for (i in seq(0,0.99,l=15)){init(SIRepi) <- c(S=0.01,I=i,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
dev.off()
postscript("SIRepisimlow.eps")
times(SIRepi) <- c(to=10,by=0.02)
SIRepi@parms <- c(beta=.5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation  SIR-Epidemie-Modells mit ",beta==0.5~gamma==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIRepi) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRepi) <- c(S=i,I=0.01,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
#for (i in seq(0,0.99,l=15)){init(SIRepi) <- c(S=0.01,I=i,R=0);linearrows(out(sim(SIRepi))[,c("S","I")],length=.05)}
dev.off()

postscript("SIRepisimshigh.eps")
times(SIRepi) <- c(from=0,to=5,by=0.1)
parms(SIRepi) <- c(beta=5,gamma=1)
init(SIRepi)<-c(S=0.01,I=0.99,R=0)
a1 <- out(sim(SIRepi))
init(SIRepi)<-c(S=0.99,I=0.01,R=0)
a2 <- out(sim(SIRepi))
init(SIRepi)<-c(S=0.5,I=0.2,R=0.3)
a3 <- out(sim(SIRepi))
par(lwd=3,cex=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SIR Modell mit "*{beta==5}*" " * {gamma==1}),labels=c(expression(t),expression(S),expression(I),expression(R)),cex=15)
dev.off()

postscript("SIRepisimslow.eps")
times(SIRepi) <- c(from=0,to=5,by=0.1)
parms(SIRepi) <- c(beta=.5,gamma=1)
init(SIRepi)<-c(S=0.01,I=0.99,R=0)
a1 <- out(sim(SIRepi))
init(SIRepi)<-c(S=0.99,I=0.01,R=0)
a2 <- out(sim(SIRepi))
init(SIRepi)<-c(S=0.7,I=0.3,R=0)
a3 <- out(sim(SIRepi))
init(SIRepi)<-c(S=0.3,I=0.7,R=0)
a4 <- out(sim(SIRepi))
par(lwd=3,cex=2)
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},main=expression("SIR Modell mit "*{beta==0.5}*" " * {gamma==1}),labels=c(expression(t),expression(S),expression(I),expression(R)),cex=15)
dev.off()


SIRende<- new("odeModel",
             times=c(from=0,to=10,by=0.02),
             parms=c(b=1,beta=5,gamma=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             { with(as.list(c(init,parms)),{
               dS.dt <- -beta*I*S +b*I+b*R
               dI.dt <- beta*I*S -gamma*I -b*I
               dR.dt <- gamma*I -b*R
               list(c(dS.dt,dI.dt,dR.dt))})},
             init=c(S=0.99,I=0.01,R=0)
             )
             



par(oma=rep(0,4),mar=rep(1,4));
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIRende) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRende) <- c(S=i,I=0.01,R=0);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRende) <- c(S=0.01,I=i,R=0);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}

postscript("SIRendefieldhigh.eps")
SIRende@parms <- c(b=1,beta=5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIR-Endemie-Modells mit ",beta==5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm(SIRende@main(0.0,init=c(S=i,I=j,R=1-i-j),parms=SIRende@parms)[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
postscript("SIRendefieldlow.eps")
SIRende@parms <- c(b=1,beta=.5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIR-Endemie-Modells mit ",beta==0.5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm(SIRende@main(0.0,init=c(S=i,I=j,R=1-i-j),parms=SIRende@parms)[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
postscript("SIRendesimhigh.eps")
times(SIRende) <- c(to=10,by=0.02)
SIRende@parms <- c(b=1,beta=5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation  SIR-Endemie-Modells mit ",beta==5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIRende) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRende) <- c(S=i,I=0.01,R=0.99-i);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRende) <- c(S=0.01,I=i,R=0.99-i);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
dev.off()
postscript("SIRendesimlow.eps")
times(SIRende) <- c(to=10,by=0.02)
SIRende@parms <- c(b=1,beta=.5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation  SIR-Endemie-Modells mit ",beta==0.5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIRende) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRende) <- c(S=i,I=0.01,R=0.99-i);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIRende) <- c(S=0.01,I=i,R=0.99-i);linearrows(out(sim(SIRende))[,c("S","I")],length=.05)}
dev.off()

postscript("SIRendesimshigh.eps")
times(SIRende) <- c(from=0,to=5,by=0.1)
parms(SIRende) <- c(b=1,beta=5,gamma=1)
init(SIRende)<-c(S=0.01,I=0.99,R=0)
a1 <- out(sim(SIRende))
init(SIRende)<-c(S=0.99,I=0.01,R=0)
a2 <- out(sim(SIRende))
init(SIRende)<-c(S=0.5,I=0.2,R=0.3)
a3 <- out(sim(SIRende))
par(lwd=3,cex=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SIR Endemie mit "*{beta==5}*" " * {gamma==1}*" "*{b==1}),labels=c(expression(t),expression(S),expression(I),expression(R)),cex=15)
dev.off()

postscript("SIRendesimslow.eps")
times(SIRende) <- c(from=0,to=5,by=0.1)
parms(SIRende) <- c(b=1,beta=.5,gamma=1)
init(SIRende)<-c(S=0.01,I=0.99,R=0)
a1 <- out(sim(SIRende))
init(SIRende)<-c(S=0.99,I=0.01,R=0)
a2 <- out(sim(SIRende))
init(SIRende)<-c(S=0.7,I=0.3,R=0)
a3 <- out(sim(SIRende))
init(SIRende)<-c(S=0.3,I=0.7,R=0)
a4 <- out(sim(SIRende))
par(lwd=3,cex=2)
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},main=expression("SIR Endemie mit "*{beta==0.5}*" " * {gamma==1}*" "*{b==1}),labels=c(expression(t),expression(S),expression(I),expression(R)),cex=15)
dev.off()




SEISepi <- SIRepi
SEISepi@main <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
 { with(as.list(c(init,parms)),{
 dS.dt <- -beta*I*S  +gamma*I
 dE.dt <- beta*I*S -delta*E 
 dI.dt <- delta*E -gamma*I 
 list(c(dS.dt,dE.dt,dI.dt))})}

SEISepi@init <- c(S=0.99,E=0,I=0.01)
SEISepi@parms <- c(beta=5,gamma=1,delta=1)

times(SEISepi) <- c(to=10,by=0.05)
par(oma=rep(0,4),mar=rep(1,4));
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=20)){init(SEISepi) <- c(S=i,E=0,I=1-i);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SEISepi) <- c(S=i,E=0,I=0.01);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SEISepi) <- c(S=0.01,E=0,I=i);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}

postscript("SEISepifieldhigh.eps")
parms(SEISepi) <- c(beta=5,gamma=1,delta=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SEIS-Epidemie-Modells mit ",beta==5~gamma==1~delta==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm((SEISepi@main(0.0,init=c(S=i,E=1-i-j,I=j),parms=SEISepi@parms)[[1]])[c(1,3)])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
postscript("SEISepifieldlow.eps")
parms(SEISepi) <- c(beta=.5,gamma=1,delta=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SEIS-Epidemie-Modells mit ",beta==0.5~gamma==1~delta==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm((SEISepi@main(0.0,init=c(S=i,E=1-i-j,I=j),parms=SEISepi@parms)[[1]])[c(1,3)])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
postscript("SEISepisimhigh.eps")
times(SEISepi) <- c(from=0,to=10,by=0.1)
parms(SEISepi) <- c(beta=5,gamma=1,delta=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation  SEIS-Epidemie-Modell mit ",beta==5~gamma==1~delta==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SEISepi) <- c(S=i,E=0,I=1-i);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SEISepi) <- c(S=i,E=0.99-i,I=0.01);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SEISepi) <- c(S=0.01,E=0.99-i,I=i);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
dev.off()
postscript("SEISepisimlow.eps")
times(SEISepi) <- c(from=0,to=10,by=0.1)
parms(SEISepi) <- c(beta=.5,gamma=1,delta=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation  SEIS-Epidemie-Modell mit ",beta==0.5~gamma==1~delta==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SEISepi) <- c(S=i,E=0,I=1-i);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SEISepi) <- c(S=i,E=0.99-i,I=0.01);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SEISepi) <- c(S=0.01,E=0.99-i,I=i);linearrows(out(sim(SEISepi))[,c("S","I")],length=.05)}
dev.off()

postscript("SEISepisimshigh.eps")
times(SEISepi) <- c(from=0,to=10,by=0.1)
parms(SEISepi) <- c(beta=5,gamma=1,delta=1)
init(SEISepi)<-c(S=0.01,E=0,I=0.99)
a1 <- out(sim(SEISepi))
init(SEISepi)<-c(S=0.99,E=0,I=0.01)
a2 <- out(sim(SEISepi))
init(SEISepi)<-c(S=0.5,E=0.3,I=0.2)
a3 <- out(sim(SEISepi))
par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SEIS Modell mit "*{beta==5}*" " * {gamma==1}*" " * {delta==1}),labels=c(expression(t),expression(S),expression(E),expression(I)),cex=15)
dev.off()

postscript("SEISepisimslow.eps")
times(SEISepi) <- c(from=0,to=10,by=0.1)
parms(SEISepi) <- c(beta=.5,gamma=1,delta=1)
init(SEISepi)<-c(S=0.01,E=0,I=0.99)
a1 <- out(sim(SEISepi))
init(SEISepi)<-c(S=0.8,E=0,I=0.2)
a2 <- out(sim(SEISepi))
init(SEISepi)<-c(S=0.5,E=0.3,I=0.2)
a3 <- out(sim(SEISepi))
par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SEIS Modell mit "*{beta==0.5}*" " * {gamma==1}*" " * {delta==1}),labels=c(expression(t),expression(S),expression(E),expression(I)),cex=15)
dev.off()

SISepi <- SIRepi
SISepi@main <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
 { with(as.list(c(init,parms)),{
 dS.dt <- -beta*I*S  +gamma*I
  dI.dt <- beta*I*S -gamma*I 
 list(c(dS.dt,dI.dt))})}

SISepi@init <- c(S=0.99,I=0.01)
SISepi@parms <- c(beta=5,gamma=1)

times(SISepi) <- c(from=0,to=10,by=0.05)
par(oma=rep(0,4),mar=rep(1,4));
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=20)){init(SISepi) <- c(S=i,I=1-i);linearrows(out(sim(SISepi))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SISepi) <- c(S=i,I=0.01);linearrows(out(sim(SISepi))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SISepi) <- c(S=0.01,I=i);linearrows(out(sim(SISepi))[,c("S","I")],length=.05)}

#sinnlos
postscript("SISepifieldhigh.eps")
parms(SISepi) <- c(beta=5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIS-Epidemie-Modells mit ",beta==5~gamma==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm((SISepi@main(0.0,init=c(S=i,I=j),parms=SISepi@parms)[[1]]))
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
#sinnlos
postscript("SISepifieldlow.eps")
parms(SISepi) <- c(beta=.5,gamma=1)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIS-Epidemie-Modells mit ",beta==.5~gamma==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm((SISepi@main(0.0,init=c(S=i,I=j),parms=SISepi@parms)[[1]]))
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()

postscript("SISepisimhigh.eps")
times(SISepi) <- c(from=0,to=10,by=0.1)
parms(SISepi) <- c(beta=5,gamma=1)
init(SISepi)<-c(S=0.01,I=0.99)
a1 <- out(sim(SISepi))
init(SISepi)<-c(S=0.99,I=0.01)
a2 <- out(sim(SISepi))
init(SISepi)<-c(S=0.5,I=0.5)
a3 <- out(sim(SISepi))



par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SIS Modell mit "*{beta==5}*" " * {gamma==1}),labels=c(expression(t),expression(S),expression(I)),cex=15)

dev.off()
postscript("SISepisimlow.eps")
times(SISepi) <- c(from=0,to=10,by=0.1)
parms(SISepi) <- c(beta=.5,gamma=1)
init(SISepi)<-c(S=0.01,I=0.99)
a1 <- out(sim(SISepi))
init(SISepi)<-c(S=0.99,I=0.01)
a2 <- out(sim(SISepi))
init(SISepi)<-c(S=0.5,I=0.5)
a3 <- out(sim(SISepi))



par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SIS Modell mit "*{beta==0.5}*" " * {gamma==1}),labels=c(expression(t),expression(S),expression(I)),cex=15)

dev.off()



SIepi <- SIRepi
SIepi@main <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
 { with(as.list(c(init,parms)),{
 dS.dt <- -beta*I*S  
  dI.dt <- beta*I*S 
 list(c(dS.dt,dI.dt))})}

SIepi@init <- c(S=0.99,I=0.01)
SIepi@parms <- c(beta=5)

times(SIepi) <- c(from=0,to=10,by=0.05)

postscript("SIsim.eps")

parms(SIepi) <- c(beta=1)
init(SIepi)<-c(S=0.1,I=0.9)
a1 <- out(sim(SIepi))
init(SIepi)<-c(S=0.99,I=0.01)
a2 <- out(sim(SIepi))
init(SIepi)<-c(S=0.5,I=0.5)
a3 <- out(sim(SIepi))



par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SI Modell mit "*{beta==1}),labels=c(expression(t),expression(S),expression(I)),cex=15)

dev.off()

SIREndemieimpft <- SIRepi
SIREndemieimpft@main <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
 { with(as.list(c(init,parms)),{
 dS.dt <- b*(1-p)-beta*I*S -b*S
 dI.dt <- beta*I*S -gamma*I -b*I
 dR.dt <- b*p+gamma*I -b*R
 list(c(dS.dt,dI.dt,dR.dt))})}
SIREndemieimpft@init <- c(S=1,I=0,R=0)
SIREndemieimpft@parms <- c(beta=5,gamma=1,b=1,p=0.5)

par(oma=rep(0,4),mar=rep(1,4));
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,ann=F,xla="",yla="",ax=F,frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=i,I=1-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.01)}
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=i,I=0.01);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.01)}
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=0.01,I=i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.01)}
postscript("SIREndimpfsimhigh.eps")
times(SIREndemieimpft) <- c(from=0,to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=5,gamma=1,b=1,p=0.25)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation SIR-Endemie-Modells mit Impfung,  ",beta==5~gamma==1~b==1~p==0.25)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIREndemieimpft) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIREndemieimpft) <- c(S=i,I=0.01,R=0.99-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIREndemieimpft) <- c(S=0.01,I=i,R=0.99-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
dev.off()
postscript("SIREndimpfsimhighlow.eps")
times(SIREndemieimpft) <- c(to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=5,gamma=1,b=1,p=0.65)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation SIR-Endemie-Modells mit Impfung,  ",beta==5~gamma==1~b==1~p==0.65)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIREndemieimpft) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIREndemieimpft) <- c(S=i,I=0.01,R=0.99-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIREndemieimpft) <- c(S=0.01,I=i,R=0.99-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
dev.off()
postscript("SIREndimpffieldhighlow.eps")
times(SIREndemieimpft) <- c(to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=5,gamma=1,b=1,p=0.65)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIR-Endemie-Modells mit Impfung,  ",beta==5~gamma==1~b==1~p==0.65)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm((SIREndemieimpft@main(0.0,init=c(S=i,I=j,R=1-i-j),parms=SIREndemieimpft@parms)[[1]])[1:2])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()
postscript("SIREndimpfsimlow.eps")
times(SIREndemieimpft) <- c(to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=1,gamma=1,b=1,p=0.25)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation SIR-Endemie-Modells mit Impfung,  ",beta==1~gamma==1~b==1~p==0.25)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(SIREndemieimpft) <- c(S=i,I=1-i,R=0);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIREndemieimpft) <- c(S=i,I=0.01,R=0.99-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,0.99,l=15)){init(SIREndemieimpft) <- c(S=0.01,I=i,R=0.99-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
dev.off()

postscript("SIREndeimpftsimshigh.eps")
times(SIREndemieimpft) <- c(from=0,to=5,by=0.1)
parms(SIREndemieimpft) <- c(b=1,beta=5,gamma=1,p=0.1)
init(SIREndemieimpft)<-c(S=0.01,I=0.99,R=0)
a1 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.99,I=0.01,R=0)
a2 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.5,I=0.2,R=0.3)
a3 <- out(sim(SIREndemieimpft))
par(lwd=3,cex=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("SIR Endemie mit Impfung für "*{beta==5}*" " * {gamma==1}*" "*{b==1}*" "*{p==0.1}),labels=c(expression(t),expression(S),expression(I),expression(R)),cex=15)
dev.off()
postscript("SIREndemieimpftsimshighlow.eps")
times(SIREndemieimpft) <- c(from=0,to=5,by=0.1)
parms(SIREndemieimpft) <- c(b=1,beta=5,gamma=1,p=0.65)
init(SIREndemieimpft)<-c(S=0.01,I=0.99,R=0)
a1 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.99,I=0.01,R=0)
a2 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.7,I=0.3,R=0)
a3 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.3,I=0.7,R=0)
a4 <- out(sim(SIREndemieimpft))
par(lwd=3,cex=2)
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},main=expression("SIR Endemie mit Impfung für "*{beta==5}*" " * {gamma==1}*" "*{b==1}*" "*{p==0.65}),labels=c(expression(t),expression(S),expression(I),expression(R)),cex=15)
dev.off()

postscript("SIREndemieimpftimpfsimslow.eps")
times(SIREndemieimpft) <- c(from=0,to=5,by=0.1)
parms(SIREndemieimpft) <- c(b=1,beta=.5,gamma=1,p=0.2)
init(SIREndemieimpft)<-c(S=0.01,I=0.99,R=0)
a1 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.99,I=0.01,R=0)
a2 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.7,I=0.3,R=0)
a3 <- out(sim(SIREndemieimpft))
init(SIREndemieimpft)<-c(S=0.3,I=0.7,R=0)
a4 <- out(sim(SIREndemieimpft))
par(lwd=3,cex=2)
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},main=expression("SIR Endemie mir Impfung für "*{beta==0.5}*" " * {gamma==1}*" "*{b==1}*" "*{p==0.2}),labels=c(expression(t),expression(S),expression(I),expression(R)),cex=15)
dev.off()






postscript("SIREndsimhigh.eps")
times(SIREndemieimpft) <- c(to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=5,gamma=1,b=1,p=0)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation SIR-Endemie-Modells,  ",beta==5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=i,I=1-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=i,I=0.01);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=0.01,I=i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
dev.off()
postscript("SIREndfieldhigh.eps")
times(SIREndemieimpft) <- c(to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=5,gamma=1,b=1,p=0)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIR-Endemie-Modells,  ",beta==5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm((SIREndemieimpft@main(0.0,init=c(S=i,I=j,R=1-i-j),parms=SIREndemieimpft@parms)[[1]]))
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()

postscript("SIREndsimlow.eps")
times(SIREndemieimpft) <- c(to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=1.5,gamma=1,b=1,p=0)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Simulation SIR-Endemie-Modells,  ",beta==1.5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=i,I=1-i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=i,I=0.01);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
for (i in seq(0,1,l=20)){init(SIREndemieimpft) <- c(S=0.01,I=i);linearrows(out(sim(SIREndemieimpft))[,c("S","I")],length=.05)}
dev.off()
postscript("SIREndfieldlow.eps")
times(SIREndemieimpft) <- c(to=10,by=0.1)
parms(SIREndemieimpft) <- c(beta=1.5,gamma=1,b=1,p=0)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Empfängliche",yla="Infektiöse",main=expression(paste("Richtungsfeld des SIR-Endemie-Modells,  ",beta==1.5~gamma==1~b==1)),frame.plot=T)
lines(c(1,0),c(0,1))
for (i in seq(0.0,1,by=0.025)){
for (j in seq(0.0,1,by=.025)){
  if (i+j<=1) {z <- 0.02*norm((SIREndemieimpft@main(0.0,init=c(S=i,I=j,R=1-i-j),parms=SIREndemieimpft@parms)[[1]]))
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
dev.off()




SIS2epi <- SEISepi

SIS2epi@main <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
 { with(as.list(c(init,parms)),{
 dS1.dt <- -beta*I1*S1-betas*I2*S1 +gamma*I1
 dI1.dt <- beta*I1*S1+betas*I2*S1  -gamma*I1
 dS2.dt <- -beta*I2*S2-betas*I1*S2 +gamma*I2
 dI2.dt <- beta*I2*S2+betas*I1*S2  -gamma*I2

 list(c(dS1.dt,dI1.dt,dS2.dt,dI2.dt))})}
SIS2epi@init <- c(S1=0.95,I1=0.05,S2=0.9,I2=0.1)
SIS2epi@parms <- c(beta=5,betas=0.1,gamma=1)
times(SIS2epi) <- c(to=10,by=0.1)
SIS2out <- out(sim(SIS2epi))
plot(SIS2out[,"time"],SIS2out[,"I1"],ylim=0:1,type="n",main="Erweitertes Räuber-Beute-Modell",xlab="Zeit",ylab="Populationsdichte")
for (k in 2:5) {lines(SIS2out[,"time"],SIS2out[,k],col=k)}


par(mfrow=c(3,3))
for (t in seq(0,1,len=9)){
init(SIS2epi) <- c(S2=t,I2=1-t)
SIS2out <- out(sim(SIS2epi))
plot(SIS2out[,"time"],SIS2out[,"I1"],ylim=0:1,type="n",main=paste("SISIS Modell  für S2=",t),xlab="Zeit",ylab="Populationsdichte")
for (k in 2:5) {lines(SIS2out[,"time"],SIS2out[,k],col=k)}

}
for (t in seq(0,5,len=9)){
SIS2epi@init <- c(S1=0.95,I1=0.05,S2=0.1,I2=0.9)
 parms(SIS2epi) <- c(gamma=1,beta=5,betas=t) 
SIS2out <- out(sim(SIS2epi))
plot(SIS2out[,"time"],SIS2out[,"I1"],ylim=0:1,type="n",main=substitute(paste("SISIS Modell  für",beta[s]==t),list(t=t)),xlab="Zeit",ylab="Populationsdichte")
for (k in 2:5) {lines(SIS2out[,"time"],SIS2out[,k],col=k)}

}


sampleSIS <- function(n=10,probi=0.5,ni=2,probres=0.25,initS=10,initI=1){
  xS <- 0:(n-1)
xI <- xS
  xS[1] <- initS
xI[1] <- initI
  for (t in 1:(n-1)){
    mS <- ifelse(xS[t]>0, length(unique(sample(x=xS[t],size=ni*xI[t],rep=TRUE)[which(rbinom(n=ni*xI[t],size=1,prob=probi)==1)])),0)
    mI <- rbinom(n=1,size=xI[t],prob=probres)
    xS[t+1] <- xS[t]-mS+mI
    xI[t+1] <- xI[t]+mS-mI
  }
  return(rbind(xS,xI))
}

set.seed(1212)
plotsampleSIS <- function(n=20,probi=0.5,ni=2,probres=0.25,initS=10,initI=1,repeats=10,...){
  xyy <- matrix(0,nr=repeats,nc=n)
for (j in 1:repeats){
xyy[j,] <- sampleSIS(probi=probi,probres=probres,ni=ni,n=n,initS=initS,initI=initI)[2,]}
plot(c(apply(xyy,M=2,FUN=max),0),type="n",xlab="Generationen",ylab="Infektiöse",...)
  for (j in 1:repeats){lines(xyy[j,],col=hsv(j/repeats))}
}

plothistSIS <- function(n1=4,n2=4,probi=0.5,ni=2,probres=0.25,initS=10,initI=1,repeats=1e3,...){
  xyy <- matrix(0,nr=repeats,nc=n1*n2+1)
for (j in 1:repeats){
xyy[j,] <- sampleSIS(probi=probi,probres=probres,ni=ni,n=n1*n2+1,initS=initS,initI=initI)[2,]}
par(mfrow=c(n1,n2))
  for (i in 1: (n1*n2))
{aa <- hist (xyy[,i+1],breaks=seq(0,initS,len=11),plot=FALSE)
aa$density <-aa$counts/repeats
 aa$equidist <- FALSE
  plot(aa,xlab="Anzahl Infektiöse",ylab="rel. Häufigkeit",main=paste("nach ",i,"Schritten"))
}
}



par(bg="yellow")
plotsampleSIS(rep=20,probi=0.6,probres=0.8,main="stochastische SIS-Epidemie",n=30,initS=10)

plothistSIS(probi=0.6,probres=0.8,initS=100)
plothistSIS(n1=4,n2=4,probi=0.5,probres=0.4,initS=20)

postscript("SISstochastisch1.eps")
par(lwd=2)
plotsampleSIS(rep=20,probi=0.99,ni=50,probres=0.9999,main="stochastische SIS-Epidemie",n=30,initS=100)
dev.off()
postscript("SISstochastisch2.eps")
par(lwd=2)
plotsampleSIS(rep=20,probi=0.5,ni=2,probres=0.1,main="stochastische SIS-Epidemie",n=30,initS=10)
dev.off()
postscript("SISstochastisch3.eps")
par(lwd=2)
plotsampleSIS(rep=20,probi=0.5,ni=2,probres=0.5,main="stochastische SIS-Epidemie",n=30,initS=10)
dev.off()
postscript("SISstochastisch4.eps")
par(lwd=2)
plotsampleSIS(rep=20,probi=0.4,ni=2,probres=0.5,main="stochastische SIS-Epidemie",n=30,initS=10)
dev.off()
postscript("SISstochastisch5.eps")
par(lwd=2)
plotsampleSIS(rep=20,probi=0.9,ni=2,probres=0.5,main="stochastische SIS-Epidemie",n=30,initS=10)
dev.off()
postscript("SISstochastisch6.eps")
par(lwd=2)
plotsampleSIS(rep=20,probi=0.45,ni=4,probres=0.5,main="stochastische SIS-Epidemie",n=30,initS=10)
dev.off()

sampleSIR <- function(n=10,probi=0.5,ni=2,probres=0.25,initS=10,initI=1){
  xS <- 0:(n-1)
xI <- xS
  xS[1] <- initS
xI[1] <- initI
  xR[1] <- 0
  for (t in 1:(n-1)){
    mS <-  ifelse(xS[t]>0, length(unique(sample(x=xS[t],size=ni*xI[t],rep=TRUE)[which(rbinom(n=ni*xI[t],size=1,prob=probi)==1)])),0)
    mI <- rbinom(n=1,size=xI[t],prob=probres)
     xS[t+1] <- xS[t]-mS
    xI[t+1] <- xI[t]+mS-mI
    xR[t+1] <- xR[t]+mI
  }
  return(rbind(xS,xI,xR))
}

plotsampleSIR <- function(n=20,probi=0.5,ni=2,probres=0.25,initS=10,initI=1,repeats=10,...){
  xyy <- matrix(0,nr=repeats,nc=n)
for (j in 1:repeats){
xyy[j,] <- sampleSIR(probi=probi,probres=probres,ni=ni,n=n,initS=initS,initI=initI)[2,]}
plot(c(apply(xyy,M=2,FUN=max),0),type="n",xlab="Generationen",ylab="Infektiöse",...)
  for (j in 1:repeats){lines(xyy[j,],col=hsv(j/repeats))}
}
par(bg="yellow")
plotsampleSIR(rep=20,probi=0.6,probres=0.008,main="stochastische SIR-Epidemie",n=30,initS=100)
abline(col="blue",h=100)

length(unique(sample(x=20,size=5,rep=TRUE)[which(rbinom(n=5,size=1,prob=0.8)==1)]))

rs <- .Random.seed
.Random.seed <- rs
length(unique(sample(x=4,size=0,rep=TRUE)[which(rbinom(n=0,size=1,prob=0.001)==1)]))

sample(x=-2,size=5,rep=TRUE)

postscript("SIRstochastisch1.eps")
par(lwd=2)
plotsampleSIR(rep=20,probi=0.99,ni=50,probres=0.9999,main="stochastische SIR-Epidemie",n=30,initS=100)
dev.off()
postscript("SIRstochastisch2.eps")
par(lwd=2)
plotsampleSIR(rep=20,probi=0.5,ni=2,probres=0.1,main="stochastische SIR-Epidemie",n=30,initS=10)
dev.off()
postscript("SIRstochastisch3.eps")
par(lwd=2)
plotsampleSIR(rep=20,probi=0.5,ni=2,probres=0.5,main="stochastische SIR-Epidemie",n=30,initS=10)
dev.off()
postscript("SIRstochastisch4.eps")
par(lwd=2)
plotsampleSIR(rep=20,probi=0.4,ni=2,probres=0.5,main="stochastische SIR-Epidemie",n=30,initS=10)
dev.off()
postscript("SIRstochastisch5.eps")
par(lwd=2)
plotsampleSIR(rep=20,probi=0.9,ni=2,probres=0.5,main="stochastische SIR-Epidemie",n=30,initS=10)
dev.off()
postscript("SIRstochastisch6.eps")
par(lwd=2)
plotsampleSIR(rep=20,probi=0.45,ni=4,probres=0.5,main="stochastische SIR-Epidemie",n=30,initS=10)
dev.off()
