xx <- seq(-5,5,len=1e3)
plot(xx,exp(0.01-log(0.01)-xx^2/0.01),type="n")
i <- 1
for (t in c(0.01,0.1,1,2,3)){lines(xx,exp(t-log(t)-xx^2/t),col=(i <- i+1));}
                                                       }
legend (3,90,c(0.01,0.1,1,2,3),col=2:6,lwd=.5)
postscript("dispdensities.eps")
par(lwd=3)
plot(xx,exp(0.03-log(0.01)-xx^2/0.01),ylim=c(0,130),main="Populationsdichten exponentielles Wachstum mit Diffusion",ylab=expression(N(t,x)),xlab=expression(x),type="n")
i <- 1
for (t in c(0.01,0.1,0.5,1,2,3)){lines(xx,exp(2*t-log(t)-xx^2/t),col=(i <- i+1));}
                                                       }
legend (3,90,c(expression(t==0.01),expression(t==0.1),expression(t==0.5),expression(t==1),expression(t==2),expression(t==3)),col=2:7,lwd=5)
dev.off()

library("simecol")

linearrows <- function(m,...){n <- length(m[,1]);arrows(x0=m[1:n-1,1],x1=m[2:n,1],y0=m[1:n-1,2],y1=m[2:n,2],...)}
norm <- function(a){ifelse((sum(a*a)==0),0,1/sqrt(sum(a*a)))*a}
SBW <- new("odeModel",
             times=c(from=0,to=100,by=0.1),
             parms=c(c=3),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
               { with(as.list(c(init,parms)),{
                 dU.dt <- V
                 dV.dt <- -c*V-U*(0.5*(1-U/10)-U/(U^2+1))
                 list(c(dU.dt,dV.dt))
                 }
                      )
                 },
             init=c(U=0.5,V=0)
             )

plot(out(sim(SBW)),panel=lines)
times(SBW)<-c(to=50)
SBW@init= c(U=0.5,V=0)
a1 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=0.5,V=1)
a2 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=0.5,V=-1)
a3 <- out(sim(SBW))[c(1,3,2)]
par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main="Spruce-Budworm Modell, Wellenlösung",labels=c(expression(t),expression(V),expression(U)),cex=15)

postscript("sbwc3.eps")
par(lwd=3);
times(SBW)<-c(to=80)
parms(SBW)<- c(c=3)
SBW@init= c(U=0.5,V=0)
a1 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=0.5,V=1)
a2 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=0.5,V=-1)
a3 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=1,V=1)
a4 <- out(sim(SBW))[c(1,3,2)]
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},main=expression("Spruce-Budworm Modell, Wellenlösung mit "*c==3),labels=c(expression(t),expression(V),expression(U)),cex=15)
dev.off()

postscript("sbwc01.eps")
parms(SBW)<- c(c=.1)
par(lwd=3);
times(SBW)<-c(to=100)
SBW@init= c(U=0.5,V=0)
a1 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=0.5,V=1)
a2 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=0.5,V=-1)
a3 <- out(sim(SBW))[c(1,3,2)]
SBW@init<-c(U=1,V=1)
a4 <- out(sim(SBW))[c(1,3,2)]
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},main=expression("Spruce-Budworm Modell, Wellenlösung mit "*c==0.1),labels=c(expression(t),expression(V),expression(U)),cex=15)
dev.off()

plot(x=0,y=0,type="n",xlim=c(-0.5,7.5),ylim=c(-1,1),bty="o",lwd=4,xla="U",yla="V",main=expression(paste("Phasendiagramm Spruce-Budworm Modell mit ",c==.1)),frame.plot=T)
for (i in seq(-0.5,7.5,len=30)){
for (j in seq(-1,1,len=30)){
   {z <- 0.06*norm(SBW@main(0.0,init=c(U=i,V=j),parms=SBW@parms)[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.025)}
}}
postscript("sbwphasec1.eps")
par(lwd=3);
SBW@parms= c(c=0.1)
plot(x=0,y=0,type="n",xlim=c(-0.5,7.5),ylim=c(-1,1),bty="o",lwd=4,xla="U",yla="V",main=expression(paste("Phasendiagramm Spruce-Budworm Modell mit ",c==.1)),frame.plot=T)
for (i in seq(-0.5,7.5,len=30)){
for (j in seq(-1,1,len=30)){
   {z <- 0.06*norm(SBW@main(0.0,init=c(U=i,V=j),parms=SBW@parms)[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.05)}
}}
dev.off()
postscript("sbwphasec2.eps")
par(lwd=3);
SBW@parms= c(c=1)
plot(x=0,y=0,type="n",xlim=c(-0.5,7.5),ylim=c(-1,1),bty="o",lwd=4,xla="U",yla="V",main=expression(paste("Phasendiagramm Spruce-Budworm Modell mit ",c==1)),frame.plot=T)
for (i in seq(-0.5,7.5,len=30)){
for (j in seq(-1,1,len=30)){
   {z <- 0.06*norm(SBW@main(0.0,init=c(U=i,V=j),parms=SBW@parms)[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.05)}
}}
dev.off()


kk <- 100
aaa <- NULL
SBW@parms= c(c=1.1)
for (i in 1:kk){SBW@init<-c(U=runif(n=1,min=0,max=2),V=runif(n=1,min=-1,max=1));aaa[[i]] <- out(sim(SBW))[c(2,3)]}

plot(x=0,y=0,type="n",xlim=c(-0.2,2.2),ylim=c(-1.2,1.2),bty="o",lwd=4,xla="U",yla="V",main=expression(paste("Orbits Spruce-Budworm Modell mit ",c==3)),frame.plot=T)
for (i in 1:kk){lines(aaa[[i]],col=hsv(i/(kk+1)),lwd=1)}
postscript("sbwphasecurvec11.eps")
plot(x=0,y=0,type="n",xlim=c(-0.2,2.2),ylim=c(-1.2,1.2),bty="o",lwd=4,xla="U",yla="V",main=expression(paste("Orbits Spruce-Budworm Modell mit ",c==1.1)),frame.plot=T)
for (i in 1:kk){lines(aaa[[i]],col=hsv(i/(kk+1)),lwd=1)}
dev.off()


SIRsp <- new("odeModel",
             times=c(from=0,to=2,by=.1),
             parms=c(R=1.2,c=2*sqrt(1/6)),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             { with(as.list(c(init,parms)),{
               dU.dt <- -R/c*U*V
               dV.dt <- c*(U-1/R*log(U)-1+V)
               list(c(dU.dt,dV.dt))}
                    )},
init=c(U=1,V=0)
             )



times(SIRsp) <- c(from=0,to=2,by=0.1)
SIRsp@init= c(U=0.5,V=0.5)
a1 <- out(sim(SIRsp))[c(1,3,2)]
SIRsp@init<-c(U=0.3,V=0.7)
a2 <- out(sim(SIRsp))[c(1,3,2)]
SIRsp@init<-c(U=0.8,V=0.2)
a3 <- out(sim(SIRsp))[c(1,3,2)]
par(lwd=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main="räumliches SIR Modell, Wellenlösung",labels=c(expression(t),expression(V),expression(U)),cex=15)

plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,yla="Infektiöse",xla="Suszeptible",frame.plot=T)
for (i in seq(0.001,1,len=40)){
for (j in seq(0.001,1,len=40)){
 if (i+j<=1)  {z <- 0.025*norm((main(SIRsp))(time=0.0,init=c(U=i,V=j),parms=parms(SIRsp))[[1]])
  arrows(x0=i,y0=j,x1=i+z[1],y1=j+z[2],length=0.05)}
}}
lines(c(1,0),c(0,1),lwd=2)


persp(z=as.matrix(out3[1:11,1:200]),x=out2[,1],col=rainbow((out3[1:10,1:199]+out3[1:10+1,1:199]+out3[1:10,1:199+1]+out3[1:10+1,1:199+1]+1)/(4*max(out3)+2)))

myplot<-function(z,hmin=0.05,hrange=0.9,hfunc=function(z){hmin+hrange*(z-min(z))/diff(range(z))},xlab=NULL,ylab=NULL,zlab=NULL,...)
  {nc<-ncol(z);nr<-nrow(z)
   zs<- z[1:(nr-1),1:(nc-1)]+ z[2:nr,1:(nc-1)]+z[1:(nr-1),2:nc]+z[2:nr,2:nc]
    zs<-hfunc(zs)
   persp(z=z,col=hsv(zs),xlab=xlab,ylab=ylab,zlab=zlab,...)
}
library(rgl)
myplot3d<-function(z,hmin=0.05,hrange=0.9,hfunc=function(z){hmin+hrange*(z-min(z))/diff(range(z))},...)
  {persp3d(z=z,col=hsv(hfunc(z)),smooth=FALSE,...)
}





myplot(x=1:100,y=1:100,matrix(kronecker(1:100,1:100,FUN=function(u,v)(u+v)^5),nc=100),d=.10,lwd=.01,shade=0.1,phi=0,th=30,main="ein piek",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)),hm=0.99,hr=-0.985)->trafo
aabb<-trans3d(c(1,1,100,1),c(1,1,1,100),c(1,200^5,1,1),trafo)       
arrows(x0=rep(aabb$x[1],3),y0=rep(aabb$y[1],3),x1=aabb$x[2:4],y1=aabb$y[2:4],lwd=4,col=1)




x <- seq(-1,1,len=1e2)
y <- seq(-1,1,len=1e2)

heatk <- function(x,y,t,alpha=0){exp(alpha*t-.25*(x^2+y^2)/t)/t}


postscript("diff0.eps")
myplot(x=x,y=y,z=outer(x,y,FUN=heatk,t=0.001),zlim=0:1,zlab=expression(N(t,x)),main=expression(paste("Diffusion zur Zeit ", t==0.001)))
dev.off()
postscript("diff1.eps")
myplot(x=x,y=y,z=outer(x,y,FUN=heatk,t=0.01),zlim=0:1,zlab="u",main=expression(paste("Diffusion zur Zeit ", t==0.01)))
dev.off()
postscript("diff2.eps")
myplot(x=x,y=y,z=outer(x,y,FUN=heatk,t=0.1),zlim=0:1,zlab="u",main=expression(paste("Diffusion zur Zeit ", t==0.1)))
dev.off()
postscript("diff3.eps")
myplot(x=x,y=y,z=outer(x+0.5,y+0.25,FUN=heatk,t=0.001)+outer(x,y,FUN=heatk,t=0.001)+outer(x-0.25,y-0.7,FUN=heatk,t=0.001),zlab="u",main=expression(paste("Diffusion zur Zeit ", t==0.001)))
dev.off()
postscript("diff4.eps")
myplot(x=x,y=y,z=outer(x+0.5,y+0.25,FUN=heatk,t=0.01)+outer(x,y,FUN=heatk,t=0.01)+outer(x-0.25,y-0.7,FUN=heatk,t=0.01),zlab="u",main=expression(paste("Diffusion zur Zeit ", t==0.01)))
dev.off()
postscript("diff5.eps")
myplot(x=x,y=y,z=outer(x+0.5,y+0.25,FUN=heatk,t=0.1)+outer(x,y,FUN=heatk,t=0.1)+outer(x-0.25,y-0.7,FUN=heatk,t=0.1),zlab="u",main=expression(paste("Diffusion zur Zeit ", t==0.1)))
dev.off()




Diff2 <- new("odeModel",
             times=c(from=0,to=20,by=.1),
             parms=c(D=1,nnc=50,nnr=50,p=2,e=0),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
              ls()
              #nnc<-parms["nnc"];nnr<-parms["nnr"];p<-parms["p"];D<-parms["D"];
              ds1<-ds2<-ss<-matrix(init,nc=nnc,nr=nnr)
              ds1[3:(nnr-2),]<- -2*ss[3:(nnr-2),]+ss[3:(nnr-2)-1,]+ss[3:(nnr-2)+1,]
              ds1[1,]<-ss[2,]-(p+e)*ss[1,]
             ds1[2,]<- p*ss[1,]-2*ss[2,]+ss[3,]
              ds1[nnr,]<-ss[nnr-1,]-(p+e)*ss[nnr,]
             ds1[nnr-1,]<-ss[nnr-2,]+p*ss[nnr,]-2*ss[nnr-1,]
              ds2[,3:(nnc-2)]<- -2*ss[,3:(nnc-2)]+ss[,3:(nnc-2)-1]+ss[,3:(nnc-2)+1]
              ds2[,1]<-ss[,2]-(p+e)*ss[,1]
             ds2[,2]<- p*ss[,1]-2*ss[,2]+ss[,3]
             ds2[,nnc]<-ss[,nnc-1]-(p+e)*ss[,nnc]
             ds2[,nnc-1]<-ss[,nnc-2]+p*ss[,nnc]-2*ss[,nnc-1]
               list(c(D*(ds1+ds2)))})
              },
             init=0
             )
parms(Diff2)<-c(D=.5,nnc=51,nnr=51,p=1,e=0)
init(Diff2)<-c(kronecker(0:50-25,0:50-25,function(u,v) (u^2+v^2)/1250))
times(Diff2)<-c(to=25)
xyz<-out(sim(Diff2))
             par(mfrow=c(4,2),ask=F)
for(t in c(1,11,31,61,71,81,100,150))             
{myplot(x=0:50-25,y=0:50-25,z=matrix(as.numeric(xyz[t,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),main=substitute({t==tt},list(tt=xyz[t,1])))
}       

myplot3d(x=0:50-25,y=0:50-25,z=matrix(as.numeric(xyz[26,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),main=paste(substitute({t==tt},list(tt=xyz[26,1]))))

             
        


Diff1 <- new("odeModel",
             times=c(from=0,to=20,by=.1),
             parms=c(D=1,nn=500,p=2,e=0),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
             ds<-init
              ds[3:(nn-2)]<- -2*init[3:(nn-2)]+init[3:(nn-2)-1]+init[3:(nn-2)+1]
              ds[1]<-init[2]-(p+e)*init[1]
             ds[2]<- p*init[1]-2*init[2]+init[3]
              ds[nn]<-init[nn-1]-(p+e)*init[nn]
             ds[nn-1]<-init[nn-2]+p*init[nn]-2*init[nn-1]
               list(c(D*ds))})
              },
             init=0
             )
parms(Diff1)<-c(D=5e3,nn=1001,p=1,e=0)
init(Diff1)<-((-500:500)/500)^2)
times(Diff1)<-c(to=20)
xyz1<-out(sim(Diff1))
             
myplot3d(x=xyz1[,1],y=-500:500,z=as.matrix(xyz1[,2:1002]),zlim=c(0,1),main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))

myplot(x=xyz1[,1],y=-500:500,z=as.matrix(xyz1[,2:1002]),zlim=c(0,1),theta=0,lwd=.1,main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))


Diff1N <- new("odeModel",
             times=c(from=0,to=20,by=.1),
             parms=c(D=1,nn=500),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
             ds<-init
              ds[2:(nn-1)]<- -2*init[2:(nn-1)]+init[2:(nn-1)-1]+init[2:(nn-1)+1]
              ds[1]<-init[2]-init[1]
              ds[nn]<-init[nn-1]-init[nn]
               list(c(D*ds))})
              },
             init=rep(0,500)
             )
parms(Diff1N)<-c(D=5e1,nn=101)
init(Diff1N)<-((-50:50)/50)^2
times(Diff1N)<-c(to=20)
xyz1N<-out(sim(Diff1N))
             
myplot3d(x=xyz1N[,1],y=-50:50,z=as.matrix(xyz1N[,2:102]),zlim=c(0,1),main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))

postscript("diff1Dneumann1.eps")
myplot(x=xyz1N[,1],y=-50:50/50,z=as.matrix(xyz1N[,2:102]),zlim=c(0,1),theta=0,border=NA,nticks=3,lwd=2,main="1D Diffusion, Neumann Randbedingung",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("diff1Dneumann2.eps")
myplot(x=xyz1N[,1],y=-50:50/50,z=as.matrix(xyz1N[,2:102]),zlim=c(0,1),theta=-75,border=NA,nticks=3,lwd=2,main="1D Diffusion, Neumann Randbedingung",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("diff1Dneumann3.eps")
myplot(x=xyz1N[,1],y=-50:50/50,z=as.matrix(xyz1N[,2:102]),zlim=c(0,1),theta=90,border=NA,nticks=3,phi=45,lwd=2,main="1D Diffusion, Neumann Randbedingung",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()

Diff1D <- new("odeModel",
             times=c(from=0,to=20,by=.1),
             parms=c(D=1,nn=500),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
             ds<-init
              ds[2:(nn-1)]<- -2*init[2:(nn-1)]+init[2:(nn-1)-1]+init[2:(nn-1)+1]
              ds[1]<-init[2]-2*init[1]
              ds[nn]<-init[nn-1]-2*init[nn]
               list(c(D*ds))})
              },
             init=rep(0,500)
             )
parms(Diff1D)<-c(D=5e1,nn=101)
init(Diff1D)<-((-50:50)/50)^2
times(Diff1D)<-c(to=20)
xyz1D<-out(sim(Diff1D))
             
myplot3d(x=xyz1D[,1],y=-50:50,z=as.matrix(xyz1D[,2:102]),zlim=c(0,1),main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))

postscript("diff1Ddirichlet1.eps")
myplot(x=xyz1D[,1],y=-50:50/50,z=as.matrix(xyz1D[,2:102]),zlim=c(0,1),theta=0,border=NA,nticks=3,lwd=2,main="1D Diffusion, Dirichlet Randbedingung",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("diff1Ddirichlet2.eps")
myplot(x=xyz1D[,1],y=-50:50/50,z=as.matrix(xyz1D[,2:102]),zlim=c(0,1),theta=-75,border=NA,nticks=3,lwd=2,main="1D Diffusion, Dirichlet Randbedingung",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("diff1Ddirichlet3.eps")
myplot(x=xyz1D[,1],y=-50:50/50,z=as.matrix(xyz1D[,2:102]),zlim=c(0,1),theta=90,phi=45,border=NA,nticks=3,lwd=2,main="1D Diffusion, Dirichlet Randbedingung",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()

parms(Diff1)<-c(D=5e3,nn=1001,p=1,e=0)
init(Diff1)<- ((-500:500)/500)^2
times(Diff1)<-c(to=50,by=.25)
xyz2<-out(sim(Diff1))
myplot(x=xyz2[,1],y=-500:500,z=as.matrix(xyz2[,2:1002]),border=NA,zlim=c(0,1),theta=0,phi=10,lwd=3,main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))


#FKPP
FKPP1N <- new("odeModel",
             times=c(from=0,to=2,by=.1),
             parms=c(nn=500,r=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
             ds<-init
              ds[2:(nn-1)]<- -2*init[2:(nn-1)]+init[2:(nn-1)-1]+init[2:(nn-1)+1]
              ds[1]<-init[2]-init[1]
              ds[nn]<-init[nn-1]-init[nn]
               list(c(ds+r*init*(1-init)))})
              },
             init=rep(0,500)
             )
parms(FKPP1N)<-c(nn=301,r=20)
init(FKPP1N)<-pmax(1-10*abs(-150:150)/150,0)
times(FKPP1N)<-c(to=2,by=.01)
xykpp1N<-out(sim(FKPP1N))
             
myplot3d(x=xykpp1N[,1],y=-150:150/150,z=as.matrix(xykpp1N[,2:302]),zlim=c(0,1),main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))
par(ask=F)
postscript("fkpp1Dneumanncusp1.eps")
myplot(x=xykpp1N[,1],y=-150:150/150,z=as.matrix(xykpp1N[,2:302]),zlim=c(0,1),theta=-90,phi=90,border=NA,nticks=3,lwd=2,main="1D Fisher-KPP Gleichung, Neumann Randbedingung, Spitze",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("fkpp1Dneumanncusp2.eps")
myplot(x=xykpp1N[,1],y=-150:150/150,z=as.matrix(xykpp1N[,2:302]),zlim=c(0,1),theta=-85,border=NA,nticks=3,lwd=2,main="1D Fisher-KPP Gleichung, Neumann Randbedingung, Spitze",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("fkpp1Dneumanncusp3.eps")
myplot(x=xykpp1N[,1],y=-150:150/150,z=as.matrix(xykpp1N[,2:302]),zlim=c(0,1),theta=90,phi=30,border=NA,nticks=3,lwd=2,main="1D Fisher-KPP Gleichung, Neumann Randbedingung, Spitze",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
parms(FKPP1N)<-c(nn=301,r=8)
times(FKPP1N)<-c(to=2,by=.01)
init(FKPP1N)<-pmax(1-0:301/301,0)^10
xykpp1N2<-out(sim(FKPP1N))
myplot3d(x=xykpp1N2[,1],y=-150:150/150,z=as.matrix(xykpp1N2[,2:302]),zlim=c(0,1),main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))
postscript("fkpp1Dneumannwave1.eps")
myplot(x=xykpp1N2[,1],y=-150:150/150,z=as.matrix(xykpp1N2[,2:302]),zlim=c(0,1),theta=-90,phi=90,border=NA,nticks=3,lwd=2,main="1D Fisher-KPP Gleichung, Neumann Randbedingung, Front",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("fkpp1Dneumannwave2.eps")
myplot(x=xykpp1N2[,1],y=-150:150/150,z=as.matrix(xykpp1N2[,2:302]),zlim=c(0,1),theta=-85,border=NA,nticks=3,lwd=2,main="1D Fisher-KPP Gleichung, Neumann Randbedingung, Front",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()
postscript("fkpp1Dneumannwave3.eps")
myplot(x=xykpp1N2[,1],y=-150:150/150,z=as.matrix(xykpp1N2[,2:302]),zlim=c(0,1),theta=90,phi=30,border=NA,nticks=3,lwd=2,main="1D Fisher-KPP Gleichung, Neumann Randbedingung, Front",xlab=expression(t),ylab=expression(x),zlab=expression(N(t,x)),ticktype="detailed")
dev.off()

LC1N <- new("odeModel",
             times=c(from=0,to=2,by=.1),
             parms=c(nn=500,r1=1,r2=1,alpha=1,beta=1,s1=1,s2=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
             dn1<-n1<-init[1:nn]
             dn2<-n2<-init[1:nn+nn]
              dn1[2:(nn-1)]<- -2*n1[2:(nn-1)]+n1[2:(nn-1)-1]+n1[2:(nn-1)+1]
              dn1[1]<-n1[2]-n1[1]
              dn1[nn]<-n1[nn-1]-n1[nn]
              dn2[2:(nn-1)]<- -2*n2[2:(nn-1)]+n2[2:(nn-1)-1]+n2[2:(nn-1)+1]
              dn2[1]<-n2[2]-n2[1]
              dn2[nn]<-n2[nn-1]-n2[nn]
               list(c(s1*dn1+r1*n1*(1-n1-alpha*n2),s2*dn2+r2*n2*(1-beta*n1-n2)))})
              },
             init=rep(0,1000)
             )
parms(LC1N)<-c(nn=101,r1=1,r2=1,alpha=3,beta=5,s1=1,s2=1)
init(LC1N)<-c(pmax(1-abs(0:100)/100,0),pmax(1-2*abs(100:0)/100,0))
times(LC1N)<-c(to=2*10,by=.01*10)
xylc1N<-out(sim(LC1N))
             
myplot3d(x=xylc1N[,1],y=-50:50/50,z=as.matrix(xylc1N[,2:102]),zlim=c(0,1),main="1D Diffusion",xlab=expression(t),ylab=expression(x),zlab=expression(n(t,x)))
par(mfrow=c(1,2))
postscript("lc1Dneumann1.eps")
par(mfrow=c(1,2))
myplot(x=xylc1N[,1],y=-50:50/50,z=as.matrix(xylc1N[,2:102]),zlim=c(0,1),theta=-90,phi=90,border=NA,nticks=3,lwd=2,main="1D diffusive Konkurrenz, Neumann Randbedingung, Spezies 1",xlab=expression(t),ylab=expression(x),zlab=expression(N[1](t,x)),ticktype="detailed")
myplot(x=xylc1N[,1],y=-50:50/50,z=as.matrix(xylc1N[,2:102+101]),zlim=c(0,1),theta=-90,phi=90,border=NA,nticks=3,lwd=2,main="1D diffusive Konkurrenz, Neumann Randbedingung, Spezies 1",xlab=expression(t),ylab=expression(x),zlab=expression(N[2](t,x)),ticktype="detailed")            
dev.off()
postscript("lc1Dneumann2.eps")
par(mfrow=c(1,2))
myplot(x=xylc1N[,1],y=-50:50/50,z=as.matrix(xylc1N[,2:102]),zlim=c(0,1),theta=-85,border=NA,nticks=3,lwd=2,main="1D diffusive Konkurrenz, Neumann Randbedingung, Spezies 1",xlab=expression(t),ylab=expression(x),zlab=expression(N[1](t,x)),ticktype="detailed")
myplot(x=xylc1N[,1],y=-50:50/50,z=as.matrix(xylc1N[,2:102+101]),zlim=c(0,1),theta=-85,border=NA,nticks=3,lwd=2,main="1D diffusive Konkurrenz, Neumann Randbedingung, Spezies 1",xlab=expression(t),ylab=expression(x),zlab=expression(N[2](t,x)),ticktype="detailed")            
dev.off()
postscript("lc1Dneumann3.eps")
par(mfrow=c(1,2))
myplot(x=xylc1N[,1],y=-50:50/50,z=as.matrix(xylc1N[,2:102]),zlim=c(0,1),theta=90,phi=30,border=NA,nticks=3,lwd=2,main="1D diffusive Konkurrenz, Neumann Randbedingung, Spezies 1",xlab=expression(t),ylab=expression(x),zlab=expression(N[1](t,x)),ticktype="detailed")
myplot(x=xylc1N[,1],y=-50:50/50,z=as.matrix(xylc1N[,2:102+101]),zlim=c(0,1),theta=90,phi=30,border=NA,nticks=3,lwd=2,main="1D diffusive Konkurrenz, Neumann Randbedingung, Spezies 1",xlab=expression(t),ylab=expression(x),zlab=expression(N[2](t,x)),ticktype="detailed")            
dev.off()




Diff2N <- new("odeModel",
             times=c(from=0,to=20,by=.1),
             parms=c(D=1,nnc=50,nnr=50),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
              ls()
              #nnc<-parms["nnc"];nnr<-parms["nnr"];p<-parms["p"];D<-parms["D"];
              ds1<-ds2<-ss<-matrix(init,nc=nnc,nr=nnr)
              ds1[2:(nnr-1),]<- -2*ss[2:(nnr-1),]+ss[2:(nnr-1)-1,]+ss[2:(nnr-1)+1,]
              ds1[1,]<-ss[2,]-ss[1,]
              ds1[nnr,]<-ss[nnr-1,]-ss[nnr,]
              ds2[,2:(nnc-1)]<- -2*ss[,2:(nnc-1)]+ss[,2:(nnc-1)-1]+ss[,2:(nnc-1)+1]
              ds2[,1]<-ss[,2]-ss[,1]
             ds2[,nnc]<-ss[,nnc-1]-ss[,nnc]
               list(c(D*(ds1+ds2)))})
              },
             init=0
             )
parms(Diff2N)<-c(D=10,nnc=51,nnr=51)
init(Diff2N)<-c(kronecker(0:50-25,0:50-25,function(u,v) (u^2+v^2)/1250))
times(Diff2N)<-c(to=25)
xyz2N<-out(sim(Diff2N))
             par(ask=T,mfrow=c(1,1))
for(t in c(1,11,31,61,121,251))             
{myplot(x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyz2N[t,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+.9*pmin(pmax(-2.5+pmin(9*z,z+2.5),0),1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D Diffusion, Neumann Randbedingung zur Zeit "*{t==tt},list(tt=xyz2N[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(N(t,x)),ticktype="detailed")}       
postscript("neumann2Ddiffusion%03d.eps",onefile=FALSE)
par(mfrow=c(1,1))
for(t in c(1,11,31,61,121,251))             
{myplot(x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyz2N[t,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+.9*pmin(pmax(-2.5+pmin(9*z,z+2.5),0),1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D Diffusion, Neumann Randbedingung zur Zeit "*{t==tt},list(tt=xyz2N[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(N(t,x)),ticktype="detailed")}       
dev.off()


Diff2D <- new("odeModel",
             times=c(from=0,to=20,by=.1),
             parms=c(D=1,nnc=50,nnr=50),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
              ls()
              #nnc<-parms["nnc"];nnr<-parms["nnr"];p<-parms["p"];D<-parms["D"];
              ds1<-ds2<-ss<-matrix(init,nc=nnc,nr=nnr)
              ds1[2:(nnr-1),]<- -2*ss[2:(nnr-1),]+ss[2:(nnr-1)-1,]+ss[2:(nnr-1)+1,]
              ds1[1,]<-ss[2,]-2*ss[1,]
              ds1[nnr,]<-ss[nnr-1,]-2*ss[nnr,]
              ds2[,2:(nnc-1)]<- -2*ss[,2:(nnc-1)]+ss[,2:(nnc-1)-1]+ss[,2:(nnc-1)+1]
              ds2[,1]<-ss[,2]-2*ss[,1]
             ds2[,nnc]<-ss[,nnc-1]-2*ss[,nnc]
               list(c(D*(ds1+ds2)))})
              },
             init=rep(0,2500)
             )
parms(Diff2D)<-c(D=10,nnc=51,nnr=51)
init(Diff2D)<-c(kronecker(0:50-25,0:50-25,function(u,v) (u^2+v^2)/1250))
times(Diff2D)<-c(to=25)
xyz2D<-out(sim(Diff2D))
             par(ask=T,mfrow=c(1,1))
for(t in c(1,11,31,61,121,251))             
{myplot(x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyz2D[t,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+0.9*pmin(z,1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D Diffusion, Dirichlet Randbedingung zur Zeit "*{t==tt},list(tt=xyz2D[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(N(t,x)),ticktype="detailed")}       
 postscript("dirichlet2Ddiffusion%03d.eps",onefile=FALSE)
par(mfrow=c(1,1))
for(t in c(1,11,31,61,121,251))             
{myplot(x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyz2D[t,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+0.9*pmin(z,1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D Diffusion, Dirichlet Randbedingung zur Zeit "*{t==tt},list(tt=xyz2D[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(N(t,x)),ticktype="detailed")}       
dev.off()

SIR2D <- new("odeModel",
             times=c(from=0,to=20,by=.1),
             parms=c(D=1,nnc=50,nnr=50,beta=1,gamma=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
             {with(as.list(parms),{
              ds1<-ds2<-ss<-matrix(init[1:(nnc*nnr)],nc=nnc,nr=nnr)
              ii<-matrix(init[1:(nnc*nnr)+nnc*nnr],nc=nnc,nr=nnr)
              ds1[2:(nnr-1),]<- -2*ii[2:(nnr-1),]+ii[2:(nnr-1)-1,]+ii[2:(nnr-1)+1,]
              ds1[1,]<-ii[2,]-ii[1,]
              ds1[nnr,]<-ii[nnr-1,]-ii[nnr,]
              ds2[,2:(nnc-1)]<- -2*ii[,2:(nnc-1)]+ii[,2:(nnc-1)-1]+ii[,2:(nnc-1)+1]
              ds2[,1]<-ii[,2]-ii[,1]
             ds2[,nnc]<-ii[,nnc-1]-ii[,nnc]
               list(c(-beta*ss*ii,beta*ss*ii-gamma*ii+D*(ds1+ds2)))})
              },
             init=rep(0,5000)
             )
parms(SIR2D)<-c(D=1,nnc=51,nnr=51,beta=2,gamma=1)
init(SIR2D)<-c(kronecker(0:50-25,0:50-25,function(u,v) 1-exp(-(u^2+v^2)/5)),kronecker(0:50-25,0:50-25,function(u,v) exp(-(u^2+v^2)/5)))
times(SIR2D)<-c(to=50,by=.2)
xyzsir2D<-out(sim(SIR2D))
             par(mfrow=c(1,2))
for(t in c(1,11,31,61,121,251))             
{myplot(ask=FALSE,x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyzsir2D[t,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+0.9*pmin(z,1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D SIR-Diffusion, Empfängliche zur Zeit "*{t==tt},list(tt=xyz2D[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(N(t,x)),ticktype="detailed")       
 myplot(ask=TRUE,x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyzsir2D[t,(1:2601)+2602]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+0.9*pmin(z,1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D SIR-Diffusion, Infektiöse zur Zeit "*{t==tt},list(tt=xyz2D[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(N(t,x)),ticktype="detailed")}       
 postscript("SIR2Ddiffusion%03d.eps",onefile=FALSE)
par(mfrow=c(1,2))
for(t in c(1,11,31,61,121,251))             
{myplot(x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyzsir2D[t,(1:2601)+1]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+0.9*pmin(z,1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D SIR-Diffusion, Empfängliche zur Zeit "*{t==tt},list(tt=xyz2D[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(S(t,x)),ticktype="detailed")       
 myplot(ask=TRUE,x=(0:50-25)/25,y=(0:50-25)/25,z=matrix(as.numeric(xyzsir2D[t,(1:2601)+2602]),nc=51,nr=51),zlim=c(0,1),hfunc=function(z)0.05+0.9*pmin(z,1),theta=90,phi=45,border=NA,nticks=3,lwd=2,
        main=substitute("2D SIR-Diffusion, Infektiöse zur Zeit "*{t==tt},list(tt=xyz2D[t,1])),xlab=expression(x[1]),ylab=expression(x[2]),zlab=expression(I(t,x)),ticktype="detailed")}       
dev.off()
