library("simecol")	#wir laden das package
linearrows <- function(m,...){n <- length(m[,1]);arrows(x0=m[1:n-1,1],x1=m[2:n,1],y0=m[1:n-1,2],y1=m[2:n,2],...)}
norm <- function(a){ifelse((sum(a*a)==0),0,1/sqrt(sum(a*a)))*a}

michaelismenten<- new("odeModel",
             times=c(from=0,to=10,by=0.01),
             parms=c(k1p=40,k1m=25,k2=15),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
{   with(as.list(c(parms,init)),{
    dS.dt <- -k1p*S*E + k1m*C
    dE.dt <- -k1p*S*E + (k1m+k2)*C
    dC.dt <- k1p*S*E - (k1m+k2)*C
    dP.dt <- k2*C
        list(c(dS.dt,dE.dt,dC.dt,dP.dt))}
)
},
             init=c(S=1,E=.01,C=0,P=0)
             )
init(michaelismenten)<-c(S=1,E=.01,C=0,P=0)
parms(michaelismenten)<-c(k1p=40,k1m=25,k2=15)
times(michaelismenten)<-c(from=0,to=40,by=0.01)
ms1<-as.data.frame(out(sim(michaelismenten)))
postscript("BriggsHaldanelinlong.eps")
matplot(ms1[,1],ms1[,2:5],col=2:5,xlab="Zeit", ylab="Konzentrationen",lwd=5,pch=19,type="l",main="Lösung der Briggs-Haldane Gleichungen")
legend(0,0.6,c(expression(S),expression(E),expression(C),expression(P)),col=2:5,lwd=5)
dev.off()
postscript("BriggsHaldanelinlongspecial.eps")
matplot(ms1[,1],cbind(ms1[,2],100*ms1[,3],100*ms1[,4],ms1[,5]),col=2:5,xlab="Zeit", ylab="Konzentrationen",lwd=5,pch=19,type="l",main="Lösung der Briggs-Haldane Gleichungen")
legend(30,0.6,c(expression(S),expression(100%*%E),expression(100%*%C),expression(P)),col=2:5,lwd=5)
dev.off()
times(michaelismenten)<-c(from=0,to=.4,by=0.001)
postscript("BriggsHaldanelinshortspecial.eps")
ms2<-as.data.frame(out(sim(michaelismenten)))
matplot(ms2[,1],cbind(ms2[,2],100*ms2[,3],100*ms2[,4],ms2[,5]),col=2:5,xlab="Zeit", ylab="Konzentrationen",lwd=5,pch=19,type="l",main="Lösung der Briggs-Haldane Gleichungen")
legend(.3,0.8,c(expression(S),expression(100%*%E),expression(100%*%C),expression(P)),col=2:5,lwd=5)
dev.off()

postscript("BriggsHaldanesimSP.eps")
times(michaelismenten)<-c(from=0,to=400,by=1)
parms(michaelismenten)<-c(k1p=2,k1m=.25,k2=.15)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Substrat",yla="Produkt",main="Lösung der Briggs-Haldane Gleichungen im S-P-Bild")
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(michaelismenten) <- c(S=i,E=1,C=0,P=1-i);linearrows(out(sim(michaelismenten))[,c("S","P")],length=.05)}
for (i in seq(0,0.99,l=15)){init(michaelismenten) <- c(S=1-i,E=1-i,C=i,P=0);linearrows(out(sim(michaelismenten))[,c("S","P")],length=.05)}
for (i in seq(0,0.99,l=15)){init(michaelismenten) <- c(S=0,E=1-i,C=i,P=1-i);linearrows(out(sim(michaelismenten))[,c("S","P")],length=.05)}
dev.off()


postscript("BriggsHaldanesimSC.eps")
times(michaelismenten)<-c(from=0,to=400,by=1)
parms(michaelismenten)<-c(k1p=2,k1m=.25,k2=.15)
plot(x=0,y=0,type="n",xlim=c(0,1),ylim=c(0,1),bty="o",lwd=4,xla="Substrat",yla="Komplex",main="Lösung der Briggs-Haldane Gleichungen im S-C-Bild")
lines(c(1,0),c(0,1))
for (i in seq(0,1,l=15)){init(michaelismenten) <- c(S=i,E=1,C=0,P=1-i);linearrows(out(sim(michaelismenten))[,c("S","C")],length=.05)}
for (i in seq(0,0.99,l=15)){init(michaelismenten) <- c(S=1-i,E=1-i,C=i,P=0);linearrows(out(sim(michaelismenten))[,c("S","C")],length=.05)}
for (i in seq(0,0.99,l=15)){init(michaelismenten) <- c(S=0,E=1-i,C=i,P=1-i);linearrows(out(sim(michaelismenten))[,c("S","C")],length=.05)}
dev.off()

postscript("BriggsHaldanesimfull.eps")
times(michaelismenten)<-c(from=0,to=20,by=.1)
init(michaelismenten) <- c(S=1,E=1,C=0,P=0)
a1 <- out(sim(michaelismenten))
init(michaelismenten) <- c(S=1,E=0.5,C=0.5,P=0)
a2 <- out(sim(michaelismenten))
init(michaelismenten) <- c(S=0.5,E=0.8,C=0.2,P=0.3)
a3 <- out(sim(michaelismenten))
par(lwd=4,cex=2)
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main=expression("Lösung der Briggs-Haldane Gleichungen mit "*{k["+"]^1==2}*", "*{k["-"]^1==0.25}*", "* {k^2==0.15}),labels=c("Zeit","Substrat","Enzym","Komplex","Produkt"),cex=15)
dev.off()







