quadri <- function(u,beta=1){(beta*u+u^2)/(1+2*beta*u+u^2)}
xtt <- seq(0.01,10,len=1e4)
postscript("hanes.eps")
par(lwd=2.5)
plot(xtt,xtt/quadri(xtt,b=10),ylim=c(0,15),type="l",ylab=expression(x/S(x)),xlab=expression(x),main="Hanes Plot für kooperative Ligandenbindung",col=1)
lines(xtt,xtt/quadri(xtt,b=2),col=2)
lines(xtt,xtt/quadri(xtt,b=1),col=3)
lines(xtt,xtt/quadri(xtt,b=0.5),col=4)
lines(xtt,xtt/quadri(xtt,b=0.1),col=5)
legend(.3,12,as.expression(sapply(c(0.1,0.5,1,2,10),function(i) substitute(frac(K*minute,K)==jj,env=list(jj=i^2)))),col=5:1,lwd=5)
dev.off()
postscript("scatchard.eps")
par(lwd=2.5)
plot(quadri(xtt,b=10),quadri(xtt,b=10)/xtt,xlim=0:1,ylim=c(0,10),type="l",ylab=expression(S(x)/x),xlab=expression(S(x)),main="Scatchard Plot für kooperative Ligandenbindung",col=1)
lines(quadri(xtt,b=2),quadri(xtt,b=2)/xtt,col=2)
lines(quadri(xtt,b=1),quadri(xtt,b=1)/xtt,col=3)
lines(quadri(xtt,b=0.5),quadri(xtt,b=0.5)/xtt,col=4)
lines(quadri(xtt,b=0.1),quadri(xtt,b=0.1)/xtt,col=5)
legend(.8,8,as.expression(sapply(c(0.1,0.5,1,2,10),function(i) substitute(frac(K*minute,K)==jj,env=list(jj=i^2)))),col=5:1,lwd=5)
dev.off()
postscript("eadie-hofstee.eps")
par(lwd=2.5)
plot(y=quadri(xtt,b=10),x=quadri(xtt,b=10)/xtt,ylim=0:1,xlim=c(0,10),type="l",xlab=expression(S(x)/x),ylab=expression(S(x)),main="Eadie–Hofstee Plot für kooperative Ligandenbindung",col=1)
lines(y=quadri(xtt,b=2),x=quadri(xtt,b=2)/xtt,col=2)
lines(y=quadri(xtt,b=1),x=quadri(xtt,b=1)/xtt,col=3)
lines(y=quadri(xtt,b=0.5),x=quadri(xtt,b=0.5)/xtt,col=4)
lines(y=quadri(xtt,b=0.1),x=quadri(xtt,b=0.1)/xtt,col=5)
legend(8,.8,as.expression(sapply(c(0.1,0.5,1,2,10),function(i) substitute(frac(K*minute,K)==jj,env=list(jj=i^2)))),col=5:1,lwd=5)
dev.off()
postscript("lineweaver-burk.eps")
par(lwd=2.5)
xtt <- seq(0.1,10,len=1e4)
plot(y=1/quadri(xtt,b=10),x=1/xtt,ylim=c(0,20),xlim=c(0,10),type="l",ylab=expression(1/S(x)),xlab=expression(1/x),main="Lineweaver-Burk Plot für kooperative Ligandenbindung",col=1)
lines(y=1/quadri(xtt,b=2),x=1/xtt,col=2)
lines(y=1/quadri(xtt,b=1),x=1/xtt,col=3)
lines(y=1/quadri(xtt,b=0.5),x=1/xtt,col=4)
lines(y=1/quadri(xtt,b=0.1),x=1/xtt,col=5)
legend(0,20,as.expression(sapply(c(0.1,0.5,1,2,10),function(i) substitute(frac(K*minute,K)==jj,env=list(jj=i^2)))),col=5:1,lwd=5)
dev.off()

postscript("hill.eps")
par(lwd=2.5)
xtt <- seq(0.1,10,len=1e4)
plot(y=log(quadri(xtt,b=10)/(1-quadri(xtt,b=10))),x=log(xtt),ylim=c(-5,5),type="l",ylab=expression(log(S(x)/(1-S(x)))),xlab=expression(log(x)),main="Hill Plot für kooperative Ligandenbindung",col=1)
lines(y=log(quadri(xtt,b=2)/(1-quadri(xtt,b=2))),x=log(xtt),col=2)
lines(y=log(quadri(xtt,b=1)/(1-quadri(xtt,b=1))),x=log(xtt),col=3)
lines(y=log(quadri(xtt,b=0.5)/(1-quadri(xtt,b=0.5))),x=log(xtt),col=4)
lines(y=log(quadri(xtt,b=0.1)/(1-quadri(xtt,b=0.1))),x=log(xtt),col=5)
legend(-2,5,as.expression(sapply(c(0.1,0.5,1,2,10),function(i) substitute(frac(K*minute,K)==jj,env=list(jj=i^2)))),col=5:1,lwd=5)
dev.off()

library("simecol")	#wir laden das package
liganden<- new("odeModel",
             times=c(from=0,to=10,by=0.01),
             parms=c(k1p=1,k1m=0.2,k2p=1,k2m=0.1,k3p=1,k3m=0.1,k4p=1,k4m=0.1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
{   with(as.list(c(parms,init)),{
    dAA.dt <- -(k1p+k2p)*AA*L +k1m*AB+k2m*BA
    dAB.dt <- -(k1m+k3p*L)*AB +k3m*BB+k1p*AA*L
    dBA.dt <- -(k2m+k4p*L)*BA +k4m*BB+k2p*AA*L
    dBB.dt <- -(k3m+k4m)*BB +(k3p*AB+k4p*BA)*L
    dL.dt <- -((k1p+k2p)*AA+k3p*AB+k4p*BA)*L+(k1m*AB+k2m*BA+(k3m+k4m)*BB)
        list(c(dAA.dt,dAB.dt,dBA.dt,dBB.dt,dL.dt))}
)
}
,
             init=c(AA=1,AB=0,BA=0,BB=0,L=1)
             )

ligout <- out(sim(liganden))
plot(ligout[,1],ligout[,2],ylim=range(as.matrix(ligout[,2:6])),type="n",main="Ligandenbindung",xlab="Zeit",ylab="Konzentration")
for (i in 2:6){lines(ligout[,1],ligout[,i],col=i)}
legend (6,0.9,names(ligout)[2:6],col=2:6,lwd=5)


postscript("Liganden1.eps")
init(liganden)<-c(AA=1,AB=0,BA=0,BB=0,L=1)	# ditto
parms(liganden) <- c(k1p=1,k1m=0.2,k2p=1,k2m=0.1,k3p=1,k3m=0.1,k4p=1,k4m=0.1)
ligout <- out(sim(liganden))
plot(ligout[,1],ligout[,2],ylim=range(as.matrix(ligout[,2:6])),type="n",main="Ligandenbindung",xlab="Zeit",ylab="Konzentration")
par(lwd=2.5)
for (i in 2:6){lines(ligout[,1],ligout[,i],col=i)}
legend (6,0.9,names(ligout)[2:6],col=2:6,lwd=5)
dev.off()




feedbackpositive<-new("odeModel",
             times=c(from=0,to=100,by=.1),
             parms=c(k1=2,k2=1,k3=1,k4=1,d1=1,d2=1,d3=1,h=1),
             solver="lsoda",
             main=function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
{   with(as.list(c(parms,init)),{
    dM.dt <- -d1*M + k1/(1+(P/k2)^h)*(P/k2)^h
    dE.dt <- k3*M -d2*E
    dP.dt <- k4*E -d3*P
            list(c(dM.dt,dE.dt,dP.dt))}
)
}
,
             init=c(M=1,E=.001,P=0)
             )

plot(out(sim(feedbackpositive)),panel=lines,main="positive Rückkopplung")
init(feedbackpositive)<-c(M=1,E=.001,P=0)	# ditto
plot(out(sim(feedbackpositive)),panel=lines,main="positive Rückkopplung")

parms(feedbackpositive) <- c(k1=0.9,k2=1,k3=1,k4=1,d1=1,d2=1,d3=1,h=1)
init(feedbackpositive)<-c(M=0.1,E=1,P=.1)	# ditto
a1 <- out(sim(feedbackpositive))
init(feedbackpositive)<-c(M=1,E=.001,P=0)	# ditto
a2 <- out(sim(feedbackpositive))
pairs(rbind(a1,a2),panel=function(x,y,...){m <- length(x)/2;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...)},main="positive Rückkopplung")
init(feedbackpositive)<-c(M=.1,E=.001,P=1)	# ditto
a3 <- out(sim(feedbackpositive))
pairs(rbind(a1,a2,a3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},main="positive Rückkopplung")
postscript("positivefeedback31.eps")
parms(feedbackpositive) <- c(k1=0.9,k2=1,k3=1,k4=1,d1=1,d2=1,d3=1,h=2)
times(feedbackpositive) <- c(to=20,by=.1)
init(feedbackpositive)<-c(M=0.1,E=1,P=.1)  # ditto
a1 <- out(sim(feedbackpositive))
init(feedbackpositive)<-c(M=1,E=.001,P=0)	# ditto
a2 <- out(sim(feedbackpositive))
init(feedbackpositive)<-c(M=.1,E=.001,P=1)	# ditto
a3 <- out(sim(feedbackpositive))
init(feedbackpositive)<-c(M=1,E=1,P=1)  # ditto
a4 <- out(sim(feedbackpositive))
par(lwd=3)
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="positive Rückkopplung, starker Abbau")
dev.off()
postscript("positivefeedback32.eps")
parms(feedbackpositive) <- c(k1=1.3,k2=1,k3=1,k4=1,d1=.8,d2=.8,d3=.8,h=2)
times(feedbackpositive) <- c(to=100,by=.1)
init(feedbackpositive)<-c(M=0.1,E=1,P=.1)  # ditto
a1 <- out(sim(feedbackpositive))
init(feedbackpositive)<-c(M=1,E=.001,P=0)  # ditto
a2 <- out(sim(feedbackpositive))
init(feedbackpositive)<-c(M=.1,E=.001,P=1)	# ditto
a3 <- out(sim(feedbackpositive))
init(feedbackpositive)<-c(M=1,E=1,P=1)  # ditto
a4 <- out(sim(feedbackpositive))
par(lwd=3)
pairs(rbind(a1,a2,a3,a4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="positive Rückkopplung, schwacher Abbau")
dev.off()


feedbackpositivea <- feedbackpositive
times(feedbackpositivea) <- c(to=10,by=.01)
main(feedbackpositivea) <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
{   with(as.list(c(parms,init)),{
    dM.dt <- -d1*M + k1/(1+(P/k2)^h)*(P/k2)^h
    dE.dt <- k3*M/(k5+M) -(d2+k4)*E
    dP.dt <- k4*E -d3*P
            list(c(dM.dt,dE.dt,dP.dt))}
)
}
init(feedbackpositivea)<-c(M=0.1,E=.1,P=.1)	# ditto
parms(feedbackpositivea) <- c(k1=.9,k2=1,k3=1,k4=1,k5=3,d1=1,d2=1,d3=1,h=2)
init(feedbackpositivea)<-c(M=0.1,E=1,P=.1)	# ditto
b1 <- out(sim(feedbackpositivea))
feedbackpositivea@init<-c(M=1,E=.001,P=0)	# ditto
b2 <- out(sim(feedbackpositivea))
feedbackpositivea@init<-c(M=.1,E=.001,P=.1)	# ditto
b3 <- out(sim(feedbackpositivea))
par(lwd=3)
pairs(rbind(b1,b2,b3),panel=function(x,y,...){m <- length(x)/3;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="positive Rückkopplung")


postscript("positivefeedbacka31.eps")
parms(feedbackpositivea) <- c(k1=.9,k2=1,k3=1,k4=1,k5=1,d1=1,d2=1,d3=1,h=2)
times(feedbackpositivea) <- c(to=8,by=.1)
init(feedbackpositivea)<-c(M=0.1,E=1,P=.1)  # ditto
b1 <- out(sim(feedbackpositivea))
init(feedbackpositivea)<-c(M=1,E=.001,P=0)  # ditto
b2 <- out(sim(feedbackpositivea))
init(feedbackpositivea)<-c(M=.1,E=.001,P=.1)  # ditto
b3 <- out(sim(feedbackpositivea))
init(feedbackpositivea)<-c(M=1,E=1,P=1)  # ditto
b4 <- out(sim(feedbackpositivea))
par(lwd=3)
pairs(rbind(b1,b2,b3,b4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="positive Rückkopplung,nichtlineare Translation, starker Abbau")
dev.off()



postscript("positivefeedbacka32.eps")
parms(feedbackpositivea) <- c(k1=.9,k2=1,k3=1,k4=2,k5=1,d1=1,d2=1,d3=0.1,h=2)
times(feedbackpositivea) <- c(to=70,by=.1)
init(feedbackpositivea)<-c(M=0.1,E=1,P=.1)  # ditto
b1 <- out(sim(feedbackpositivea))
init(feedbackpositivea)<-c(M=1,E=.001,P=0)  # ditto
b2 <- out(sim(feedbackpositivea))
init(feedbackpositivea)<-c(M=.1,E=.001,P=.1)  # ditto
b3 <- out(sim(feedbackpositivea))
init(feedbackpositivea)<-c(M=1,E=1,P=1)  # ditto
b4 <- out(sim(feedbackpositivea))
par(lwd=3)
pairs(rbind(b1,b2,b3,b4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="positive Rückkopplung, nichtlineare Translation, schwacher Abbau")
dev.off()

feedbackpositiveb <- feedbackpositive
parms(feedbackpositiveb) <- c(k1=.9,k2=1,k3=1,k4=1,k5=3,k6=1,d1=1,d2=1,h=2)
times(feedbackpositiveb) <- c(to=10,by=.01)
main(feedbackpositiveb) <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
{   with(as.list(c(parms,init)),{
    dM.dt <- -d1*M + k1/(1+(P/k2)^h)*(P/k2)^h
    dE.dt <- k3*M-k4*E/(k5+E)-d2*E
    dP.dt <- k4*E/(k5+E) -k6*P
            list(c(dM.dt,dE.dt,dP.dt))}
)
}
postscript("positivefeedbackb31.eps")
parms(feedbackpositiveb) <- c(k1=.9,k2=1,k3=1,k4=1,k5=3,k6=1,d1=1,d2=1,h=4)
times(feedbackpositiveb) <- c(to=10,by=.01)
init(feedbackpositiveb)<-c(M=1.5,E=0.6,P=.1)  # ditto
b1 <- out(sim(feedbackpositiveb))
init(feedbackpositiveb)<-c(M=1,E=.001,P=0)  # ditto
b2 <- out(sim(feedbackpositiveb))
init(feedbackpositiveb)<-c(M=.1,E=.001,P=.1)  # ditto
b3 <- out(sim(feedbackpositiveb))
init(feedbackpositiveb)<-c(M=1,E=1,P=1)  # ditto
b4 <- out(sim(feedbackpositiveb))
par(lwd=3)
pairs(rbind(b1,b2,b3,b4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="positive Rückkopplung, nichtlineare Aktivierung, starker Abbau")
dev.off()
postscript("positivefeedbackb32.eps")
parms(feedbackpositiveb) <- c(k1=.9,k2=1,k3=1,k4=7,k5=3,k6=0.3,d1=1,d2=1,h=4)
times(feedbackpositiveb) <- c(to=50,by=.1)
init(feedbackpositiveb)<-c(M=1.5,E=0.6,P=.1)  # ditto
b1 <- out(sim(feedbackpositiveb))
init(feedbackpositiveb)<-c(M=1,E=.001,P=0)  # ditto
b2 <- out(sim(feedbackpositiveb))
init(feedbackpositiveb)<-c(M=.4,E=.1,P=.1)  # ditto
b3 <- out(sim(feedbackpositiveb))
init(feedbackpositiveb)<-c(M=1,E=1,P=1)  # ditto
b4 <- out(sim(feedbackpositiveb))
par(lwd=3)
pairs(rbind(b1,b2,b3,b4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="positive Rückkopplung, nichtlineare Aktivierung, schwacher Abbau")
dev.off()




feedbacknegative <- feedbackpositive
main(feedbacknegative) <- function(time, init, parms, inputs = NULL)  #hier kommt die Differentialgleichung
{   with(as.list(c(parms,init)),{
    dM.dt <- -d1*M + k1/(1+(P/k2)^h)
    dE.dt <- k3*M -d2*E
    dP.dt <- k4*E -d3*P
            list(c(dM.dt,dE.dt,dP.dt))}
)
}
init(feedbacknegative)<-c(M=1,E=.001,P=0)	# ditto
init(feedbacknegative)<-c(M=0.1,E=.1,P=.1)	# ditto
parms(feedbacknegative) <- c(k1=1,k2=.1,k3=1,k4=1,d1=1,d2=1,d3=1,h=10)
times(feedbacknegative) <- c(to=30,by=.1)
plot(out(sim(feedbacknegative)),panel=lines,main="negative Rückkopplung")


postscript("negativefeedback31.eps")
init(feedbacknegative)<-c(M=0.1,E=.1,P=.1)	# ditto
parms(feedbacknegative) <- c(k1=1,k2=.1,k3=1,k4=1,d1=1,d2=1,d3=1,h=10)
times(feedbacknegative) <- c(to=30,by=.1)
par(lwd=2)
plot(out(sim(feedbacknegative)),panel=lines,labels=c(expression(t),expression(M),expression(E),expression(P)),main="negative Rückkopplung mit hohem Hillkoeffizienten")
dev.off()

postscript("negativefeedback31a.eps")
parms(feedbacknegative) <- c(k1=1,k2=.1,k3=1,k4=1,d1=1,d2=1,d3=1,h=10)
times(feedbacknegative) <- c(to=30,by=.1)
init(feedbacknegative)<-c(M=0.1,E=1,P=.1)  # ditto
b1 <- out(sim(feedbacknegative))
init(feedbacknegative)<-c(M=1,E=.001,P=0)  # ditto
b2 <- out(sim(feedbacknegative))
init(feedbacknegative)<-c(M=.1,E=.001,P=.1)  # ditto
b3 <- out(sim(feedbacknegative))
init(feedbacknegative)<-c(M=1,E=1,P=1)  # ditto
b4 <- out(sim(feedbacknegative))
par(lwd=3)
pairs(rbind(b1,b2,b3,b4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="negative Rückkopplung mit hohem Hillkoeffizienten")
dev.off()

postscript("negativefeedback32.eps")
init(feedbacknegative)<-c(M=0.1,E=.1,P=.1)	# ditto
parms(feedbacknegative) <- c(k1=1,k2=.1,k3=1,k4=1,d1=1,d2=1,d3=1,h=1)
times(feedbacknegative) <- c(to=30,by=.1)
par(lwd=2)
plot(out(sim(feedbacknegative)),panel=lines,labels=c(expression(t),expression(M),expression(E),expression(P)),main="negative Rückkopplung mit niedrigem Hillkoeffizienten")
dev.off()

postscript("negativefeedback32a.eps")
parms(feedbacknegative) <- c(k1=1,k2=.1,k3=1,k4=1,d1=1,d2=1,d3=1,h=6)
times(feedbacknegative) <- c(to=30,by=.1)
init(feedbacknegative)<-c(M=0.1,E=1,P=.1)  # ditto
b1 <- out(sim(feedbacknegative))
init(feedbacknegative)<-c(M=1,E=.001,P=0)  # ditto
b2 <- out(sim(feedbacknegative))
init(feedbacknegative)<-c(M=.1,E=.001,P=.1)  # ditto
b3 <- out(sim(feedbacknegative))
init(feedbacknegative)<-c(M=1,E=1,P=1)  # ditto
b4 <- out(sim(feedbacknegative))
par(lwd=3)
pairs(rbind(b1,b2,b3,b4),panel=function(x,y,...){m <- length(x)/4;lines(x[1:m],y[1:m],col="red",...);lines(x[1:m+m],y[1:m+m],col="green",...);lines(x[1:m+2*m],y[1:m+2*m],col="blue",...);lines(x[1:m+3*m],y[1:m+3*m],col=5,...)},labels=c(expression(t),expression(M),expression(E),expression(P)),main="negative Rückkopplung mit niedrigem Hillkoeffizienten")
dev.off()




myplot<-function(z,hmin=0.05,hrange=0.9,...)
  {nc<-ncol(z);nr<-nrow(z)
   zs<-z[1:(nr-1),1:(nc-1)]+z[1:(nr-1)+1,1:(nc-1)]+z[1:(nr-1),1:(nc-1)+1]+z[1:(nr-1)+1,1:(nc-1)+1]
  zs<-hmin+hrange*(zs-min(zs))/diff(range(zs))
   persp(z=z,col=hsv(zs),...)
}
library(rgl)
myplot3d<-function(z,hmin=0.05,hrange=0.9,...)
  {nc<-ncol(z);nr<-nrow(z)
   zs<-z
  zs<-hmin+hrange*(zs-min(zs))/diff(range(zs))
   persp3d(z=z,col=hsv(zs),smooth=FALSE,...)
}

x<-y<-seq(-9.99999,10,by=0.2)
z<-outer(x,y,FUN=function(u,v) 1e-7*u^3-(v+5)*u)
zz<-outer(x,y,FUN=function(u,v) 1e-6*u*v)
par(mfrow=c(1,3))
myplot(x=x,y=y,z=z,lwd=0.1,phi=90,th=160)
myplot(x=x,y=y,z=z,lwd=0.1,phi=0,th=60,d=10,zlab=expression(h),xlab=expression(P),ylab=expression(delta))
myplot(x=x,y=y,z=zz,lwd=0.1,phi=0,th=60,d=10,new=TRUE,hmin=0.45,hr=0.1)

myplot(x=x,y=y,z=z,lwd=0.1,phi=0,th=100,d=10)

myplot3d(x=x,y=y,z=z,lwd=0.1,phi=0,th=60,d=10,zlab=expression(h),xlab=expression(P),ylab=expression(delta),new=TRUE)


par(mfrow=rep(4,2))

for (v in -4:11)
  plot(x,1e-7*x^3-v*x,main=substitute(b==v,list(v=v)),type="l")


