sim.chem.jump<-function(nmax=1e4,init=c(1),
                        names=paste("V",1:length(init)),
                        switchvec=matrix(data=0,ncol=1,nrow=1),
                        reacmatrix=matrix(data=1:0,ncol=2,nrow=1),
                        rates=c(1),tmax=1,
                        seed=1)
{m<-length(init)
 q<-length(rates)
 set.seed(seed)
 sim1<-rexp(n=nmax)
 sim2<-runif(n=nmax)
 out<-matrix(data=NA,nrow=nmax+1,ncol=1+m)
 #print(reacmatrix)
 tmp<-.C("sim_chemr",nmax=as.integer(nmax),as.integer(nmax+1),
         as.double(init),as.double(tmax),as.integer(m),
         as.integer(m+1),as.integer(q), 
         as.integer(matrix(reacmatrix,ncol=2,nrow=q)),as.double(rates),
         as.double(switchvec),
         as.double(sim1),as.double(sim2),out=as.double(out),
         NAOK=TRUE,PACKAGE="chemsim");
 out<-as.data.frame(matrix(data=tmp$out,nrow=nmax+1,ncol=1+m,byrow=TRUE))
 colnames(out)<-c("t",names)
 return(out[1:(tmp$nmax+1),])}

sim.general.jump<-function(nmax=1e4,init=c(1),
                        names=paste("V",1:length(init)),
                        switchfunc=function(...)0.,
                        ratesfunc=function(...)1., 
                           tmax=1,
                        seed=1)
{set.seed(seed);
 q<-length(init);
 m<-length(ratesfunc(init));
 for (i in 1:m) {if (length(switchfunc(init,i)) != q) stop("switch function has wrong dimension of output")}
 
 out<-.Call("sim_general",as.integer(nmax),
         as.double(init),as.double(tmax),
         switchfunc,environment(switchfunc),
          ratesfunc,environment(ratesfunc),
         NAOK=TRUE,PACKAGE="chemsim");
 out<-as.data.frame(out)
 colnames(out)<-c("t",names)
 return(out)}
