\encoding{utf8}
\name{sim.chem.jump}
\title{simulation of chemical reactions}
\alias{sim.chem.jump}
\usage{
sim.chem.jump(nmax=1e4,init=c(1),
                          names=paste("V",1:length(init)),
                        switchvec=matrix(data=0,ncol=1,nrow=1),
                     reacmatrix=matrix(data=1:0,ncol=2,nrow=1),
                        rates=c(1),tmax=1,
                          seed=1)
}
\arguments{
\item{nmax}{maximal number of jumps to be simulated}
  \item{init}{initial value (nonnegative integers),  should be compatible in dimension with the \code{swithvec} }
  \item{names}{names of variables}
  \item{switchvec}{stochiometric matrix, change of variable states during reactions}          
  \item{reacmatrix}{which species react in which reaction?}
  \item{rates}{reaction constants}
    \item{tmax}{maximal time}
      \item{seed}{seed for random numbers}

}
\description{
\code{sim.chem.jump} simulates a set of chemical reactions. 
}
\details{Simulations are done by simulating just the next reaction, which is the original Gillespie algorithm.

If there are \code{q} species, and \code{k} reactions, \code{switchvec} is a \code{k} by \code{q} matrix, \code{init} is a \code{q} dimensional vector, \code{rates} a \code{k} dimensional vector and \code{reacmatrix} is a \code{k} by\code{2} matrix with values in \code{\{0,1,\dots,q\}}.

\code{reacmatrix[k,1]} denotes the first reactant,  \code{reacmatrix[k,2]} the second (if any).  
}
\value{A matrix \code{out} with 
 \itemize{ \item{\code{out[,1]} being the times of jumps }
  \item{\code{out[i,2:(length(init)+1])} state vector just after time \code{out[i,1]} } }
  }
\references{
Gillespie, D. T. (1977). "Exact stochastic simulation of coupled chemical reactions". Journal of Physical Chemistry 81: 2340–2361}
\author{Volkmar Liebscher}

\keyword{Markov jump process, Gillespie algorithm, chemical reactions}
