#doppler signal from Donoho & Johnstone 1995
doppler.fun<- function(x){
  ss <- ifelse(abs(x-1/2)>1/2, 0, sqrt(x*(1-x))*sin(2*pi*1.05/(x+.05)))
  7*ss/sd(ss)  
}

dopplerdata<-rnorm(n=256,mean=doppler.fun(1:256/256))
dopplerscale<-pottsscale(y=dopplerdata,family="gauss")  
#plot 4\times4
par(mfrow=c(4,4))
plot(dopplerscale,nmax=32,col.y=1,col=2,lwd=2)
par(mfrow=c(1,1))
