\name{pottsscale}
\title{The Scale of Potts Smooths of a Time Series}
\alias{pottsscale}
\alias{pottsscalegauss}
\alias{pottsscaledoubleexp}
\alias{pottsscalebernoulli}
\alias{pottsscalembernoulli}
\alias{pottsscalemultinom}
\usage{
pottsscale(y=c(0),method="shoot",family="gauss",lmodel="const",interface="C",nmax=Inf,...)
pottsscalegauss(y=c(0),interface="C",nmax=Inf,...)
pottsscaledoubleexp(y=c(0),interface="C",nmax=Inf,...)
pottsscalebernoulli(y=c(0),interface="C",nmax=Inf,...)
pottsscalembernoulli(y=c(0),interface="C",nmax=Inf,...)
pottsscalemultinom(y=c(0),interface="C",nmax=Inf,outstepfun=TRUE,...)
}
\arguments{
  \item{y}{a vector, time series etc. coerceable to a numeric vector or matrix (for vector valued time series')}
  \item{method}{the minimization method, in the moment just the shooting method of Friedrich et al. (2008) is available.}
  \item{family}{the distribution family to use.} 
  \item{lmodel}{used local model, only constant is available at the moment.}
  \item{interface}{language used for computation of local likelihoods.}
  \item{nmax}{maximal number of different segmentation to store in the output. Those segmentations are chosen by minimal complexity.}
  \item{...}{further parameters passed to the minimisation function.}
}
\description{
  Function calculating the scale of Potts smooths which minimize a score
  
  \deqn{H_\gamma(x)=\gamma*\#\{jumps of x\} + \sum_i l(x_i,y_i)}.
  
  
  where \eqn{\gamma} is the (variable) smoothing parameter, \eqn{l(\cdot,\cdot)} is the negative log-likelihood of the \code{family}.
  
}
\details{
\code{family="gauss"} yields penalised least squares

\code{family="doubleexp"} yields penalised least absolute deviation

\code{family="bernoulli"} yields penalised Bernoulli estimation

\code{family="mbernoulli"} yields penalised multivariate Bernoulli estimation

\code{family="multinom"} yields penalised multinomial estimation
}
\value{An object of class  \link[=pottsscale-class]{pottsscale}
}
\references{
G.Winkler and V.Liebscher.
 A Potts model for segmentation and jump detection.
 In \emph{ proceedings of the SSSSG Conference Prag 1999}, 1999.

G.Winkler and V.Liebscher.
 Smoothers for discontinuous signals.
 \emph{J.Nonpar.Stat.}, 14(1-2):203--222, 2002.

F.Friedrich, A. Kempe , V. Liebscher, G. Winkler  Complexity Penalized M-Estimation: Fast Computation. J. Comput. Graph. Stat. 17(1):201--224, 2008. 
}
\author{Volkmar Liebscher}
\seealso{
  \code{\link[stats]{AIC}}, \code{\link[stats]{extractAIC}}, \code{\link[stats]{logLik}}.
}
\keyword{piecewise constant segmentation, Potts-functional, penalised
  least squares,}
